/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.provider.ProviderUtils;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.CookingTableBlockEntity;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.tag.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class KitchenImpl
implements Kitchen {
    private final ItemStack activatingItemStack;
    private final BlockState activatingBlockState;
    private final BlockEntity activatingBlockEntity;
    private final Set<BlockPos> checkedPos = new HashSet<BlockPos>();
    private final List<KitchenItemProvider> itemProviderList = new ArrayList<KitchenItemProvider>();
    private final List<KitchenItemProcessor> itemProcessorList = new ArrayList<KitchenItemProcessor>();

    public KitchenImpl(ItemStack itemStack) {
        this.activatingItemStack = itemStack;
        this.activatingBlockState = Blocks.AIR.defaultBlockState();
        this.activatingBlockEntity = null;
    }

    public KitchenImpl(Level level, BlockPos pos) {
        this.activatingBlockState = level.getBlockState(pos);
        this.activatingItemStack = ItemStack.EMPTY;
        this.activatingBlockEntity = level.getBlockEntity(pos);
        this.findNeighbourCraftingBlocks(level, pos, true);
    }

    private void findNeighbourCraftingBlocks(Level level, BlockPos pos, boolean extendedUpSearch) {
        for (Direction direction : Direction.values()) {
            int upSearch = extendedUpSearch && direction == Direction.UP ? 2 : 1;
            for (int n = 1; n <= upSearch; ++n) {
                BlockPos position = pos.relative(direction, n);
                if (this.checkedPos.contains(position)) continue;
                this.checkedPos.add(position);
                BlockState state = level.getBlockState(position);
                BlockEntity blockEntity = level.getBlockEntity(position);
                if (blockEntity != null) {
                    KitchenItemProvider itemProvider = (KitchenItemProvider)ProviderUtils.getProvider((BlockEntity)blockEntity, KitchenItemProvider.class);
                    if (itemProvider != null) {
                        this.itemProviderList.add(itemProvider);
                    } else if (state.is(ModBlockTags.KITCHEN_ITEM_PROVIDERS)) {
                        if (blockEntity instanceof Container) {
                            Container container = (Container)blockEntity;
                            this.itemProviderList.add(new ContainerKitchenItemProvider(container));
                        } else if (blockEntity instanceof BalmContainerProvider) {
                            BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
                            this.itemProviderList.add(new ContainerKitchenItemProvider(containerProvider.getContainer()));
                        }
                    }
                    KitchenItemProcessor itemProcessor = (KitchenItemProcessor)ProviderUtils.getProvider((BlockEntity)blockEntity, KitchenItemProcessor.class);
                    if (itemProcessor != null) {
                        this.itemProcessorList.add(itemProcessor);
                    }
                    if (itemProvider == null && itemProcessor == null && !state.is(ModBlockTags.KITCHEN_CONNECTORS)) continue;
                    this.findNeighbourCraftingBlocks(level, position, true);
                    continue;
                }
                if (!state.is(ModBlockTags.KITCHEN_CONNECTORS)) continue;
                this.findNeighbourCraftingBlocks(level, position, false);
            }
        }
    }

    @Override
    public List<KitchenItemProvider> getItemProviders(@Nullable Player player) {
        ArrayList<KitchenItemProvider> sourceInventories = new ArrayList<KitchenItemProvider>(this.itemProviderList);
        if (player != null) {
            sourceInventories.add(new ContainerKitchenItemProvider((Container)player.getInventory()));
        }
        return sourceInventories;
    }

    @Override
    public List<KitchenItemProcessor> getItemProcessors() {
        return this.itemProcessorList;
    }

    @Override
    public boolean canProcess(RecipeType<?> recipeType) {
        if (recipeType == RecipeType.CRAFTING) {
            return this.activatingBlockState.is(ModBlockTags.COOKING_TABLES) || this.activatingItemStack.is(ModItems.craftingBook);
        }
        return this.itemProcessorList.stream().anyMatch(it -> it.canProcess(recipeType));
    }

    public boolean isRecipeAvailable(RecipeHolder<Recipe<?>> recipe, CraftingOperation operation) {
        CookingTableBlockEntity cookingTable;
        BlockEntity blockEntity;
        boolean isNoFilter;
        boolean bl = isNoFilter = this.activatingItemStack.is(ModItems.noFilterBook) || (blockEntity = this.activatingBlockEntity) instanceof CookingTableBlockEntity && (cookingTable = (CookingTableBlockEntity)blockEntity).hasNoFilterBook();
        if (isNoFilter) {
            return true;
        }
        return operation.canCraft();
    }
}

