/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ModModels {
    public static DeferredObject<BakedModel> milkJarLiquid;
    public static DeferredObject<BakedModel> cowJarLiquid;
    public static DeferredObject<BakedModel> sinkLiquid;
    public static List<DeferredObject<BakedModel>> ovenDoors;
    public static List<DeferredObject<BakedModel>> ovenDoorHandles;
    public static List<DeferredObject<BakedModel>> ovenDoorsActive;
    public static List<DeferredObject<BakedModel>> fridgeDoors;
    public static List<DeferredObject<BakedModel>> fridgeDoorsFlipped;
    public static List<DeferredObject<BakedModel>> fridgeDoorsLargeLower;
    public static List<DeferredObject<BakedModel>> fridgeDoorsLargeUpper;
    public static List<DeferredObject<BakedModel>> fridgeDoorsLargeLowerFlipped;
    public static List<DeferredObject<BakedModel>> fridgeDoorsLargeUpperFlipped;
    public static List<DeferredObject<BakedModel>> counterDoors;
    public static List<DeferredObject<BakedModel>> counterDoorsFlipped;
    public static List<DeferredObject<BakedModel>> cabinetDoors;
    public static List<DeferredObject<BakedModel>> cabinetDoorsFlipped;

    public static void initialize(BalmModels models) {
        String colorPrefix;
        DyeColor[] colors = DyeColor.values();
        milkJarLiquid = models.loadModel(ModModels.id("block/milk_jar_liquid"));
        cowJarLiquid = models.loadModel(ModModels.id("block/cow_jar_liquid"));
        sinkLiquid = models.loadModel(ModModels.id("block/sink_liquid"));
        ovenDoors = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        ovenDoorHandles = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        ovenDoorsActive = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        fridgeDoors = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        fridgeDoorsFlipped = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        fridgeDoorsLargeLower = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        fridgeDoorsLargeUpper = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        fridgeDoorsLargeLowerFlipped = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        fridgeDoorsLargeUpperFlipped = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        models.loadModel(ModModels.id("block/dyed_oven_door_active"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            ovenDoors.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "oven_door")));
            ovenDoorsActive.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "oven_door_active")));
            ovenDoorHandles.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "oven_door_handle")));
            fridgeDoors.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "fridge_door")));
            fridgeDoorsFlipped.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "fridge_door_flipped")));
            fridgeDoorsLargeLower.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "fridge_large_door_lower")));
            fridgeDoorsLargeLowerFlipped.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "fridge_large_door_lower_flipped")));
            fridgeDoorsLargeUpper.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "fridge_large_door_upper")));
            fridgeDoorsLargeUpperFlipped.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "fridge_large_door_upper_flipped")));
        }
        counterDoors = new ArrayList<DeferredObject<BakedModel>>(colors.length + 1);
        counterDoors.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/counter_door")));
        counterDoorsFlipped = new ArrayList<DeferredObject<BakedModel>>(colors.length + 1);
        counterDoorsFlipped.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/counter_door_flipped")));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            counterDoors.add(color.getId() + 1, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "counter_door")));
            counterDoorsFlipped.add(color.getId() + 1, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "counter_door_flipped")));
        }
        cabinetDoors = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoors.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/cabinet_door")));
        cabinetDoorsFlipped = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoorsFlipped.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/cabinet_door_flipped")));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            cabinetDoors.add(color.getId() + 1, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "cabinet_door")));
            cabinetDoorsFlipped.add(color.getId() + 1, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + colorPrefix + "cabinet_door_flipped")));
        }
    }

    private static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)path);
    }
}

