/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.DoorAnimator;
import net.blay09.mods.cookingforblockheads.kitchen.CombinedKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ConditionalKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FridgeBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider<BlockPos>,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox {
    private final DefaultContainer container = new DefaultContainer(27){

        public void setChanged() {
            FridgeBlockEntity.this.isDirty = true;
            FridgeBlockEntity.this.setChanged();
        }
    };
    private final KitchenItemProvider iceUnitItemProvider = new KitchenItemProvider(this){
        private final Set<ItemStack> providedItems = Set.of(new ItemStack((ItemLike)Items.SNOWBALL), new ItemStack((ItemLike)Items.SNOW_BLOCK), new ItemStack((ItemLike)Items.ICE));

        @Override
        public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (ItemStack providedItem : this.providedItems) {
                if (!ingredient.test(providedItem)) continue;
                return new IceUnitIngredientToken(providedItem);
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (ItemStack providedItem : this.providedItems) {
                if (!ItemStack.isSameItem((ItemStack)providedItem, (ItemStack)itemStack)) continue;
                return new IceUnitIngredientToken(providedItem);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    };
    private final ContainerKitchenItemProvider conservingItemProvider = new ContainerKitchenItemProvider(this, (Container)this.container){

        @Override
        protected int getUsesLeft(int slot, ItemStack slotStack, Collection<IngredientToken> ingredientTokens) {
            return super.getUsesLeft(slot, slotStack, ingredientTokens) - 1;
        }
    };
    private final ContainerKitchenItemProvider containerItemProvider = new ContainerKitchenItemProvider((Container)this.container);
    private final KitchenItemProvider itemProvider = new CombinedKitchenItemProvider(List.of(new ConditionalKitchenItemProvider<KitchenItemProvider>(this::hasIceUpgrade, this.iceUnitItemProvider), new ConditionalKitchenItemProvider<ContainerKitchenItemProvider>(this::hasPreservationUpgrade, this.conservingItemProvider, this.containerItemProvider)));
    private final DoorAnimator doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
    private Component customName;
    private boolean isDirty;
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;

    public FridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.fridge.get(), pos, state);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen((SoundEvent)ModSounds.fridgeOpen.get());
        this.doorAnimator.setSoundEventClose((SoundEvent)ModSounds.fridgeClose.get());
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.markDirtyAndUpdate();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean triggerEvent(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.triggerEvent(id, type);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        Component customNameComponent = (Component)input.get(DataComponents.CUSTOM_NAME);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.container.deserialize(tag.getCompound("ItemHandler"), provider);
        this.hasIceUpgrade = tag.getBoolean("HasIceUpgrade");
        this.hasPreservationUpgrade = tag.getBoolean("HasPreservationUpgrade");
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        if (tag.contains("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.getBoolean("IsForcedOpen"));
        }
        if (tag.contains("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.getByte("NumPlayersUsing"));
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("ItemHandler", (Tag)this.container.serialize(provider));
        tag.putBoolean("HasIceUpgrade", this.hasIceUpgrade);
        tag.putBoolean("HasPreservationUpgrade", this.hasPreservationUpgrade);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        tag.putBoolean("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.putByte("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    @Nullable
    public FridgeBlockEntity findNeighbourFridge() {
        BlockState state = this.getBlockState();
        BlockPos posBelow = this.worldPosition.below();
        BlockState stateBelow = this.level.getBlockState(posBelow);
        BlockPos posAbove = this.worldPosition.above();
        BlockState stateAbove = this.level.getBlockState(posAbove);
        if (stateAbove.getBlock() == state.getBlock()) {
            return (FridgeBlockEntity)this.level.getBlockEntity(posAbove);
        }
        if (stateBelow.getBlock() == state.getBlock()) {
            return (FridgeBlockEntity)this.level.getBlockEntity(posBelow);
        }
        return null;
    }

    public FridgeBlockEntity getBaseFridge() {
        FridgeBlockEntity baseFridge;
        if (!this.hasLevel()) {
            return this;
        }
        BlockState state = this.getBlockState();
        BlockState stateBelow = this.level.getBlockState(this.worldPosition.below());
        if (stateBelow.getBlock() == state.getBlock() && (baseFridge = (FridgeBlockEntity)this.level.getBlockEntity(this.worldPosition.below())) != null) {
            return baseFridge;
        }
        return this;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(KitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Container getCombinedContainer() {
        FridgeBlockEntity baseFridge = this.getBaseFridge();
        FridgeBlockEntity neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedContainer(new Container[]{neighbourFridge.container, baseFridge.container});
        }
        return this.container;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition.offset(-1, 0, -1).getCenter(), this.worldPosition.offset(2, 2, 2).getCenter());
    }

    public void markDirtyAndUpdate() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new FridgeMenu(i, playerInventory, this);
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.fridge");
    }

    public Container getContainer() {
        return this.container;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    public record IceUnitIngredientToken(ItemStack itemStack) implements IngredientToken
    {
        @Override
        public ItemStack peek() {
            return this.itemStack;
        }

        @Override
        public ItemStack consume() {
            return this.itemStack;
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            return ItemStack.EMPTY;
        }
    }
}

