/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.ToolRackBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ToolRackBlock
extends BaseKitchenBlock {
    public static final MapCodec<ToolRackBlock> CODEC = ToolRackBlock.simpleCodec(ToolRackBlock::new);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] RENDER_SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), Block.box((double)14.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0)};

    public ToolRackBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD).strength(2.5f));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ToolRackBlockEntity(pos, state);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return SHAPES[facing.get3DDataValue() - 2];
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return RENDER_SHAPES[facing.get3DDataValue() - 2];
    }

    public VoxelShape getCollisionShape(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return Shapes.empty();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getClickedFace();
        if (facing == Direction.UP || facing == Direction.DOWN) {
            facing = Direction.NORTH;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ToolRackBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ToolRackBlockEntity toolRack = (ToolRackBlockEntity)blockEntity;
        int hitSlot = ToolRackBlock.getHitSlot(state, pos, blockHitResult);
        ItemStack clickedItemStack = toolRack.getContainer().getItem(hitSlot);
        if (!clickedItemStack.isEmpty()) {
            toolRack.getContainer().setItem(hitSlot, ItemStack.EMPTY);
            player.setItemInHand(InteractionHand.MAIN_HAND, clickedItemStack);
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ToolRackBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        ToolRackBlockEntity toolRack = (ToolRackBlockEntity)blockEntity;
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (itemStack.getItem() instanceof BlockItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int hitSlot = ToolRackBlock.getHitSlot(state, pos, blockHitResult);
        ItemStack oldToolItem = toolRack.getContainer().getItem(hitSlot);
        ItemStack toolItem = itemStack.split(1);
        if (!oldToolItem.isEmpty()) {
            if (!player.getInventory().add(oldToolItem)) {
                player.drop(oldToolItem, false);
            }
            toolRack.getContainer().setItem(hitSlot, toolItem);
        } else {
            toolRack.getContainer().setItem(hitSlot, toolItem);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private static int getHitSlot(BlockState state, BlockPos pos, BlockHitResult blockHitResult) {
        Direction stateFacing = (Direction)state.getValue((Property)FACING);
        double hitX = blockHitResult.getLocation().x - (double)pos.getX();
        double hitZ = blockHitResult.getLocation().z - (double)pos.getZ();
        double hit = switch (stateFacing) {
            case Direction.NORTH -> hitX;
            case Direction.SOUTH -> 1.0 - hitX;
            case Direction.WEST -> 1.0 - hitZ;
            case Direction.EAST -> hitZ;
            default -> hitX;
        };
        int hitSlot = hit > 0.5 ? 0 : 1;
        return hitSlot;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void appendHoverDescriptionText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.tool_rack.description").withStyle(ChatFormatting.GRAY));
    }
}

