/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class EntityRetrievalUtil {
    @Nullable
    public static <T extends Entity> T getNearest(Vec3 origin, List<T> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        double dist = Double.MAX_VALUE;
        Entity closest = null;
        for (Entity entity : entities) {
            double entityDist = entity.distanceToSqr(origin);
            if (!(entityDist < dist)) continue;
            dist = entityDist;
            closest = entity;
        }
        return (T)closest;
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(Entity origin, double radius, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.level(), new AABB(origin.getX() - radiusX, origin.getY() - radiusY, origin.getZ() - radiusZ, origin.getX() + radiusX, origin.getY() + radiusY, origin.getZ() + radiusZ), origin.position(), predicate);
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(Level level, AABB area, Vec3 origin, Predicate<? extends Entity> predicate) {
        Predicate<? extends Entity> typeSafePredicate = predicate;
        MutableDouble dist = new MutableDouble(Double.MAX_VALUE);
        MutableObject closest = new MutableObject(null);
        level.getEntities().get(area, entity -> {
            double entityDist;
            if (typeSafePredicate.test((Entity)entity) && (entityDist = entity.distanceToSqr(origin)) < dist.getValue()) {
                dist.setValue(entityDist);
                closest.setValue(entity);
            }
        });
        return (T)((Entity)closest.getValue());
    }

    @Nullable
    public static Player getNearestPlayer(Entity origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static Player getNearestPlayer(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin.level(), new AABB(origin.getX() - radiusX, origin.getY() - radiusY, origin.getZ() - radiusZ, origin.getX() + radiusX, origin.getY() + radiusY, origin.getZ() + radiusZ), origin.position(), predicate);
    }

    @Nullable
    public static Player getNearestPlayer(Level level, AABB area, Vec3 origin, Predicate<Player> predicate) {
        double dist = Double.MAX_VALUE;
        Player closest = null;
        for (Player player : level.players()) {
            double playerDist;
            if (!area.contains(player.position()) || !predicate.test(player) || !((playerDist = player.distanceToSqr(origin)) < dist)) continue;
            dist = playerDist;
            closest = player;
        }
        return closest;
    }

    public static List<Player> getPlayers(Level level, AABB area) {
        return EntityRetrievalUtil.getPlayers(level, area, (Player pl) -> true);
    }

    public static List<Player> getPlayers(Entity origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius, predicate);
    }

    public static List<Player> getPlayers(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(origin.level(), new AABB(origin.getX() - radiusX, origin.getY() - radiusY, origin.getZ() - radiusZ, origin.getX() + radiusX, origin.getY() + radiusY, origin.getZ() + radiusZ), predicate);
    }

    public static List<Player> getPlayers(Level level, AABB area, Predicate<Player> predicate) {
        ObjectArrayList players = new ObjectArrayList();
        for (Player player : level.players()) {
            if (!area.contains(player.position()) || !predicate.test(player)) continue;
            players.add(player);
        }
        return players;
    }

    public static <T> List<T> getEntities(Entity origin, double radius, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, predicate);
    }

    public static <T> List<T> getEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin.level(), new AABB(origin.getX() - radiusX, origin.getY() - radiusY, origin.getZ() - radiusZ, origin.getX() + radiusX, origin.getY() + radiusY, origin.getZ() + radiusZ), predicate.and(entity -> entity != origin));
    }

    public static <T> List<T> getEntities(Level level, AABB area, Predicate<? extends Entity> predicate) {
        Predicate<? extends Entity> typeSafePredicate = predicate;
        ObjectArrayList entities = new ObjectArrayList();
        level.getEntities().get(area, arg_0 -> EntityRetrievalUtil.lambda$getEntities$3(typeSafePredicate, (List)entities, arg_0));
        return entities;
    }

    private static /* synthetic */ void lambda$getEntities$3(Predicate typeSafePredicate, List entities, Entity entity) {
        if (typeSafePredicate.test(entity)) {
            entities.add(entity);
        }
    }
}

