/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class InvalidateAttackTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryStatus.REGISTERED)});
    protected BiPredicate<E, LivingEntity> customPredicate = (entity, target) -> {
        Player pl;
        return target instanceof Player && ((pl = (Player)target).isCreative() || pl.isSpectator());
    };
    protected long pathfindingAttentionSpan = 200L;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public InvalidateAttackTarget<E> invalidateIf(BiPredicate<E, LivingEntity> predicate) {
        this.customPredicate = predicate;
        return this;
    }

    public InvalidateAttackTarget<E> ignoreFailedPathfinding() {
        return this.stopTryingToPathAfter(0L);
    }

    public InvalidateAttackTarget<E> stopTryingToPathAfter(long ticks) {
        this.pathfindingAttentionSpan = ticks;
        return this;
    }

    @Override
    protected void start(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            return;
        }
        if (this.isTargetInvalid(entity, target) || !this.canAttack(entity, target) || this.isTiredOfPathing(entity) || this.customPredicate.test(entity, target)) {
            BrainUtils.clearMemory(entity, MemoryModuleType.ATTACK_TARGET);
        }
    }

    protected boolean isTargetInvalid(E entity, LivingEntity target) {
        if (entity.level() != target.level()) {
            return true;
        }
        return target.isDeadOrDying() || target.isRemoved();
    }

    protected boolean canAttack(E entity, LivingEntity target) {
        return entity.canAttack(target);
    }

    protected boolean isTiredOfPathing(E entity) {
        if (this.pathfindingAttentionSpan <= 0L) {
            return false;
        }
        Long time = (Long)BrainUtils.getMemory(entity, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        return time != null && entity.level().getGameTime() - time > this.pathfindingAttentionSpan;
    }
}

