/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.path;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetToAttackTarget<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT)});
    @Deprecated(forRemoval=true)
    protected float speedModifier = 1.0f;
    protected BiFunction<E, LivingEntity, Float> speedMod = (owner, target) -> Float.valueOf(1.0f);
    protected ToIntBiFunction<E, LivingEntity> closeEnoughWhen = (owner, target) -> 0;

    @Deprecated(forRemoval=true)
    public SetWalkTargetToAttackTarget<E> speedMod(float speedModifier) {
        return this.speedMod((owner, target) -> Float.valueOf(speedModifier));
    }

    public SetWalkTargetToAttackTarget<E> speedMod(BiFunction<E, LivingEntity, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public SetWalkTargetToAttackTarget<E> closeEnoughDist(ToIntBiFunction<E, LivingEntity> closeEnoughMod) {
        this.closeEnoughWhen = closeEnoughMod;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected void start(E entity) {
        Brain brain = entity.getBrain();
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (entity.getSensing().hasLineOfSight((Entity)target) && BehaviorUtils.isWithinAttackRange(entity, (LivingEntity)target, (int)1)) {
            BrainUtils.clearMemory(brain, MemoryModuleType.WALK_TARGET);
        } else {
            BrainUtils.setMemory(brain, MemoryModuleType.LOOK_TARGET, new EntityTracker((Entity)target, true));
            BrainUtils.setMemory(brain, MemoryModuleType.WALK_TARGET, new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), this.speedMod.apply(entity, target).floatValue(), this.closeEnoughWhen.applyAsInt(entity, target)));
        }
    }
}

