/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.core.neoforge.datagen.server;

import com.kekecreations.arts_and_crafts.common.util.ACTags;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class ArtsAndCraftsBlockTagsProvider
extends BlockTagsProvider {
    public ArtsAndCraftsBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, modId, existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider arg) {
        this.appendPickaxes();
        this.appendHoes();
        this.appendWalls();
        this.appendSlabs();
        this.appendStairs();
        this.appendHoglinRepellents();
        this.appendFlowerPots();
        this.appendWoodenDoors();
        this.appendSaplings();
        this.appendLogsThatBurn();
        this.appendLeaves();
        this.appendWoodenStairs();
        this.appendWoodenSlabs();
        this.appendWoodenButtons();
        this.appendWoodenFences();
        this.appendWoodenPressurePlates();
        this.appendWoodenTrapdoors();
        this.appendFenceGates();
        this.appendPlanks();
        this.appendAxes();
        this.appendChalkDust();
        this.appendLilyPads();
        this.appendWoolCarpets();
        this.appendWool();
    }

    private void appendWool() {
        this.tag(BlockTags.WOOL).add((Object)ACBlocks.BLEACHED_WOOL.get());
    }

    private void appendWoolCarpets() {
        this.tag(BlockTags.WOOL_CARPETS).add((Object)ACBlocks.BLEACHED_CARPET.get());
    }

    private void appendLilyPads() {
        this.tag(ACTags.BlockTags.LILY_PADS).add((Object)Blocks.LILY_PAD);
    }

    private void appendChalkDust() {
        for (DyeColor colours : DyeColor.values()) {
            this.tag(ACTags.BlockTags.CHALK_DUST).add((Object)ACBlocks.getChalkDust(colours.getId()));
        }
        this.tag(ACTags.BlockTags.CHALK_DUST).add((Object)ACBlocks.BLEACHED_CHALK_DUST.get());
    }

    private void appendHoglinRepellents() {
        for (DyeColor colours : DyeColor.values()) {
            this.tag(BlockTags.HOGLIN_REPELLENTS).add((Object)ACBlocks.getDyedPottedWarpedFungus(colours));
        }
    }

    private void appendPlanks() {
        this.tag(BlockTags.PLANKS).add((Object)ACBlocks.CORK_PLANKS.get());
    }

    private void appendWoodenButtons() {
        this.tag(BlockTags.WOODEN_BUTTONS).add((Object)((Block)ACBlocks.CORK_BUTTON.get()));
    }

    private void appendWoodenFences() {
        this.tag(BlockTags.WOODEN_FENCES).add((Object)((Block)ACBlocks.CORK_FENCE.get()));
    }

    private void appendWoodenPressurePlates() {
        this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object)((Block)ACBlocks.CORK_PRESSURE_PLATE.get()));
    }

    private void appendWoodenTrapdoors() {
        this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object)((Block)ACBlocks.CORK_TRAPDOOR.get()));
    }

    private void appendFenceGates() {
        this.tag(BlockTags.FENCE_GATES).add((Object)((Block)ACBlocks.CORK_FENCE_GATE.get()));
    }

    private void appendWoodenDoors() {
        this.tag(BlockTags.WOODEN_DOORS).add((Object)((Block)ACBlocks.CORK_DOOR.get()));
    }

    private void appendWoodenSlabs() {
        this.tag(BlockTags.WOODEN_SLABS).add((Object)((Block)ACBlocks.CORK_SLAB.get()));
    }

    private void appendWoodenStairs() {
        this.tag(BlockTags.WOODEN_STAIRS).add((Object)((Block)ACBlocks.CORK_STAIRS.get()));
    }

    private void appendAxes() {
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)ACBlocks.CORK.get()).add((Object)ACBlocks.SMOOTH_CORK.get());
    }

    private void appendHoes() {
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)((Block)ACBlocks.CORK_LEAVES.get()));
    }

    private void appendLeaves() {
        this.tag(BlockTags.LEAVES).add((Object)((Block)ACBlocks.CORK_LEAVES.get()));
    }

    private void appendLogsThatBurn() {
        this.tag(BlockTags.LOGS_THAT_BURN).add((Object)((Block)ACBlocks.CORK_LOG.get())).add((Object)((Block)ACBlocks.STRIPPED_CORK_LOG.get())).add((Object)((Block)ACBlocks.CORK_WOOD.get())).add((Object)((Block)ACBlocks.STRIPPED_CORK_WOOD.get()));
    }

    private void appendSaplings() {
        this.tag(BlockTags.SAPLINGS).add((Object)((Block)ACBlocks.CORK_SAPLING.get()));
    }

    private void appendWalls() {
        this.tag(BlockTags.WALLS).add((Object)((Block)ACBlocks.TERRACOTTA_SHINGLE_WALL.get())).add((Object)((Block)ACBlocks.SOAPSTONE_WALL.get())).add((Object)((Block)ACBlocks.SOAPSTONE_BRICK_WALL.get())).add((Object)((Block)ACBlocks.POLISHED_SOAPSTONE_WALL.get())).add((Object)((Block)ACBlocks.GYPSUM_WALL.get())).add((Object)((Block)ACBlocks.GYPSUM_BRICK_WALL.get())).add((Object)((Block)ACBlocks.POLISHED_GYPSUM_WALL.get()));
        for (DyeColor colours : DyeColor.values()) {
            this.tag(BlockTags.WALLS).add((Object)ACBlocks.getDyedTerracottaShingleWall(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneWall(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneBrickWall(colours.getId())).add((Object)ACBlocks.getDyedPolishedSoapstoneWall(colours.getId())).add((Object)ACBlocks.getDyedMudBrickWall(colours.getId()));
        }
    }

    private void appendSlabs() {
        this.tag(BlockTags.SLABS).add((Object)((Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get())).add((Object)((Block)ACBlocks.SOAPSTONE_SLAB.get())).add((Object)((Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get())).add((Object)((Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get())).add((Object)((Block)ACBlocks.GYPSUM_SLAB.get())).add((Object)((Block)ACBlocks.GYPSUM_BRICK_SLAB.get())).add((Object)((Block)ACBlocks.POLISHED_GYPSUM_SLAB.get()));
        for (DyeColor colours : DyeColor.values()) {
            this.tag(BlockTags.SLABS).add((Object)ACBlocks.getDyedTerracottaShingleSlab(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneSlab(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneBrickSlab(colours.getId())).add((Object)ACBlocks.getDyedPolishedSoapstoneSlab(colours.getId())).add((Object)ACBlocks.getDyedMudBrickSlab(colours.getId()));
        }
    }

    private void appendStairs() {
        this.tag(BlockTags.STAIRS).add((Object)((Block)ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get())).add((Object)((Block)ACBlocks.SOAPSTONE_STAIRS.get())).add((Object)((Block)ACBlocks.SOAPSTONE_BRICK_STAIRS.get())).add((Object)((Block)ACBlocks.POLISHED_SOAPSTONE_STAIRS.get())).add((Object)((Block)ACBlocks.GYPSUM_STAIRS.get())).add((Object)((Block)ACBlocks.GYPSUM_BRICK_STAIRS.get())).add((Object)((Block)ACBlocks.POLISHED_GYPSUM_STAIRS.get()));
        for (DyeColor colours : DyeColor.values()) {
            this.tag(BlockTags.STAIRS).add((Object)ACBlocks.getDyedTerracottaShingleStairs(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneStairs(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneBrickStairs(colours.getId())).add((Object)ACBlocks.getDyedPolishedSoapstoneStairs(colours.getId())).add((Object)ACBlocks.getDyedMudBrickStairs(colours.getId()));
        }
    }

    private void appendPickaxes() {
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)ACBlocks.TERRACOTTA_SHINGLES.get()).add((Object)((Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get())).add((Object)((Block)ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get())).add((Object)((Block)ACBlocks.TERRACOTTA_SHINGLE_WALL.get())).add((Object)ACBlocks.SOAPSTONE.get()).add((Object)((Block)ACBlocks.SOAPSTONE_SLAB.get())).add((Object)((Block)ACBlocks.SOAPSTONE_STAIRS.get())).add((Object)((Block)ACBlocks.SOAPSTONE_WALL.get())).add((Object)ACBlocks.SOAPSTONE_BRICKS.get()).add((Object)((Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get())).add((Object)((Block)ACBlocks.SOAPSTONE_BRICK_STAIRS.get())).add((Object)((Block)ACBlocks.SOAPSTONE_BRICK_WALL.get())).add((Object)ACBlocks.POLISHED_SOAPSTONE.get()).add((Object)((Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get())).add((Object)((Block)ACBlocks.POLISHED_SOAPSTONE_STAIRS.get())).add((Object)((Block)ACBlocks.POLISHED_SOAPSTONE_WALL.get())).add((Object)((Block)ACBlocks.PLASTER.get())).add((Object)ACBlocks.GYPSUM.get()).add((Object)((Block)ACBlocks.GYPSUM_SLAB.get())).add((Object)((Block)ACBlocks.GYPSUM_STAIRS.get())).add((Object)((Block)ACBlocks.GYPSUM_WALL.get())).add((Object)ACBlocks.GYPSUM_BRICKS.get()).add((Object)((Block)ACBlocks.GYPSUM_BRICK_SLAB.get())).add((Object)((Block)ACBlocks.GYPSUM_BRICK_STAIRS.get())).add((Object)((Block)ACBlocks.GYPSUM_BRICK_WALL.get())).add((Object)ACBlocks.POLISHED_GYPSUM.get()).add((Object)((Block)ACBlocks.POLISHED_GYPSUM_SLAB.get())).add((Object)((Block)ACBlocks.POLISHED_GYPSUM_STAIRS.get())).add((Object)((Block)ACBlocks.POLISHED_GYPSUM_WALL.get()));
        for (DyeColor colours : DyeColor.values()) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)ACBlocks.getDyedTerracottaShingles(colours.getId())).add((Object)ACBlocks.getDyedTerracottaShingleStairs(colours.getId())).add((Object)ACBlocks.getDyedTerracottaShingleSlab(colours.getId())).add((Object)ACBlocks.getDyedTerracottaShingleWall(colours.getId())).add((Object)ACBlocks.getDyedSoapstone(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneStairs(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneSlab(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneWall(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneBricks(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneBrickStairs(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneBrickSlab(colours.getId())).add((Object)ACBlocks.getDyedSoapstoneBrickWall(colours.getId())).add((Object)ACBlocks.getDyedPolishedSoapstone(colours.getId())).add((Object)ACBlocks.getDyedPolishedSoapstoneStairs(colours.getId())).add((Object)ACBlocks.getDyedPolishedSoapstoneSlab(colours.getId())).add((Object)ACBlocks.getDyedPolishedSoapstoneWall(colours.getId())).add((Object)ACBlocks.getDyedMudBricks(colours.getId())).add((Object)ACBlocks.getDyedMudBrickStairs(colours.getId())).add((Object)ACBlocks.getDyedMudBrickSlab(colours.getId())).add((Object)ACBlocks.getDyedMudBrickWall(colours.getId())).add((Object)ACBlocks.getChalk(colours.getId())).add((Object)ACBlocks.getDyedPlaster(colours.getId()));
        }
    }

    private void appendFlowerPots() {
        for (DyeColor colours : DyeColor.values()) {
            this.tag(BlockTags.FLOWER_POTS).add((Object)ACBlocks.getDyedFlowerPot(colours.getId())).add((Object)ACBlocks.getDyedPottedCrimsonFungus(colours)).add((Object)ACBlocks.getDyedPottedCrimsonRoots(colours)).add((Object)ACBlocks.getDyedPottedWarpedFungus(colours)).add((Object)ACBlocks.getDyedPottedWarpedRoots(colours)).add((Object)ACBlocks.getDyedPottedOakSapling(colours)).add((Object)ACBlocks.getDyedPottedSpruceSapling(colours)).add((Object)ACBlocks.getDyedPottedBirchSapling(colours)).add((Object)ACBlocks.getDyedPottedJungleSapling(colours)).add((Object)ACBlocks.getDyedPottedAcaciaSapling(colours)).add((Object)ACBlocks.getDyedPottedCherrySapling(colours)).add((Object)ACBlocks.getDyedPottedDarkOakSapling(colours)).add((Object)ACBlocks.getDyedPottedMangrovePropagule(colours)).add((Object)ACBlocks.getDyedPottedFern(colours)).add((Object)ACBlocks.getDyedPottedDandelion(colours)).add((Object)ACBlocks.getDyedPottedPoppy(colours)).add((Object)ACBlocks.getDyedPottedBlueOrchid(colours)).add((Object)ACBlocks.getDyedPottedAllium(colours)).add((Object)ACBlocks.getDyedPottedAzureBluet(colours)).add((Object)ACBlocks.getDyedPottedRedTulip(colours)).add((Object)ACBlocks.getDyedPottedOrangeTulip(colours)).add((Object)ACBlocks.getDyedPottedWhiteTulip(colours)).add((Object)ACBlocks.getDyedPottedPinkTulip(colours)).add((Object)ACBlocks.getDyedPottedOxeyeDaisy(colours)).add((Object)ACBlocks.getDyedPottedCornflower(colours)).add((Object)ACBlocks.getDyedPottedLilyOfTheValley(colours)).add((Object)ACBlocks.getDyedPottedWitherRose(colours)).add((Object)ACBlocks.getDyedPottedRedMushroom(colours)).add((Object)ACBlocks.getDyedPottedBrownMushroom(colours)).add((Object)ACBlocks.getDyedPottedDeadBush(colours)).add((Object)ACBlocks.getDyedPottedCactus(colours)).add((Object)ACBlocks.getDyedPottedBamboo(colours)).add((Object)ACBlocks.getDyedPottedAzalea(colours)).add((Object)ACBlocks.getDyedPottedFloweringAzalea(colours)).add((Object)ACBlocks.getDyedPottedTorchFlower(colours)).add((Object)ACBlocks.getDyedPottedCorkSapling(colours));
        }
    }
}

