/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.core.neoforge.datagen.client;

import com.kekecreations.arts_and_crafts.ArtsAndCrafts;
import com.kekecreations.arts_and_crafts.common.misc.ACBlockStateProperties;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ArtsAndCraftsBlockStateProvider
extends BlockStateProvider {
    public ArtsAndCraftsBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.cubeAllWithItem(ACBlocks.GYPSUM.get());
        this.cubeAllWithItem(ACBlocks.GYPSUM_BRICKS.get());
        this.cubeAllWithItem(ACBlocks.POLISHED_GYPSUM.get());
        this.stairsWithItem(ACBlocks.GYPSUM_STAIRS.get(), ACBlocks.GYPSUM.get());
        this.stairsWithItem(ACBlocks.GYPSUM_BRICK_STAIRS.get(), ACBlocks.GYPSUM_BRICKS.get());
        this.stairsWithItem(ACBlocks.POLISHED_GYPSUM_STAIRS.get(), ACBlocks.POLISHED_GYPSUM.get());
        this.slabWithItem(ACBlocks.GYPSUM_SLAB.get(), ACBlocks.GYPSUM.get());
        this.slabWithItem(ACBlocks.GYPSUM_BRICK_SLAB.get(), ACBlocks.GYPSUM_BRICKS.get());
        this.slabWithItem(ACBlocks.POLISHED_GYPSUM_SLAB.get(), ACBlocks.POLISHED_GYPSUM.get());
        this.wallWithItem(ACBlocks.GYPSUM_WALL.get(), ACBlocks.GYPSUM.get());
        this.wallWithItem(ACBlocks.GYPSUM_BRICK_WALL.get(), ACBlocks.GYPSUM_BRICKS.get());
        this.wallWithItem(ACBlocks.POLISHED_GYPSUM_WALL.get(), ACBlocks.POLISHED_GYPSUM.get());
        this.cubeAllWithItem(ACBlocks.SOAPSTONE.get());
        this.cubeAllWithItem(ACBlocks.SOAPSTONE_BRICKS.get());
        this.cubeAllWithItem(ACBlocks.POLISHED_SOAPSTONE.get());
        this.stairsWithItem(ACBlocks.SOAPSTONE_STAIRS.get(), ACBlocks.SOAPSTONE.get());
        this.stairsWithItem(ACBlocks.SOAPSTONE_BRICK_STAIRS.get(), ACBlocks.SOAPSTONE_BRICKS.get());
        this.stairsWithItem(ACBlocks.POLISHED_SOAPSTONE_STAIRS.get(), ACBlocks.POLISHED_SOAPSTONE.get());
        this.slabWithItem(ACBlocks.SOAPSTONE_SLAB.get(), ACBlocks.SOAPSTONE.get());
        this.slabWithItem(ACBlocks.SOAPSTONE_BRICK_SLAB.get(), ACBlocks.SOAPSTONE_BRICKS.get());
        this.slabWithItem(ACBlocks.POLISHED_SOAPSTONE_SLAB.get(), ACBlocks.POLISHED_SOAPSTONE.get());
        this.wallWithItem(ACBlocks.SOAPSTONE_WALL.get(), ACBlocks.SOAPSTONE.get());
        this.wallWithItem(ACBlocks.SOAPSTONE_BRICK_WALL.get(), ACBlocks.SOAPSTONE_BRICKS.get());
        this.wallWithItem(ACBlocks.POLISHED_SOAPSTONE_WALL.get(), ACBlocks.POLISHED_SOAPSTONE.get());
        this.cubeAllWithItem(ACBlocks.TERRACOTTA_SHINGLES.get());
        this.stairsWithItem(ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get(), ACBlocks.TERRACOTTA_SHINGLES.get());
        this.slabWithItem(ACBlocks.TERRACOTTA_SHINGLE_SLAB.get(), ACBlocks.TERRACOTTA_SHINGLES.get());
        this.wallWithItem(ACBlocks.TERRACOTTA_SHINGLE_WALL.get(), ACBlocks.TERRACOTTA_SHINGLES.get());
        this.cubeAllWithItem(ACBlocks.BLEACHED_WOOL.get());
        this.carpetWithItem(ACBlocks.BLEACHED_CARPET.get(), ACBlocks.BLEACHED_WOOL.get());
        this.chalkDustBlock(ACBlocks.BLEACHED_CHALK_DUST.get(), "bleached");
        this.cubeAllWithItem(ACBlocks.BLEACHED_CHALK.get());
        this.glazedTerracottaWithItem(ACBlocks.GLAZED_TERRACOTTA.get(), "glazed_terracotta");
        this.concretePowderWithItem(ACBlocks.BLEACHED_CONCRETE_POWDER.get());
        this.cubeAllWithItem(ACBlocks.BLEACHED_CONCRETE.get());
        this.bedBlock(ACBlocks.BLEACHED_BED.get(), "bleached_bed");
        this.logWithItem(ACBlocks.CORK_LOG.get());
        this.logWithItem(ACBlocks.STRIPPED_CORK_LOG.get());
        this.logWithItem(ACBlocks.CORK_WOOD.get());
        this.logWithItem(ACBlocks.STRIPPED_CORK_WOOD.get());
        this.doorBlock(ACBlocks.CORK_DOOR.get(), "cork", ArtsAndCrafts.id("block/cork_door_bottom"), ArtsAndCrafts.id("block/cork_door_top"));
        this.cubeAllWithItem(ACBlocks.CORK.get());
        this.cubeAllWithItem(ACBlocks.SMOOTH_CORK.get());
        this.cubeAllWithItem((Block)ACBlocks.CORK_LEAVES.get());
        this.simpleBlock((Block)ACBlocks.CORK_SAPLING.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cork_sapling", "minecraft:block/cross")).texture("cross", "block/cork_sapling"));
        this.cubeAllWithItem(ACBlocks.CORK_PLANKS.get());
        this.stairsWithItem(ACBlocks.CORK_STAIRS.get(), ACBlocks.CORK_PLANKS.get());
        this.slabWithItem(ACBlocks.CORK_SLAB.get(), ACBlocks.CORK_PLANKS.get());
        this.fenceWithItem(ACBlocks.CORK_FENCE.get(), ACBlocks.CORK_PLANKS.get());
        this.fenceGateWithItem(ACBlocks.CORK_FENCE_GATE.get(), ACBlocks.CORK_PLANKS.get());
        this.pressurePlateWithItem(ACBlocks.CORK_PRESSURE_PLATE.get(), ACBlocks.CORK_PLANKS.get());
        this.buttonWithItem(ACBlocks.CORK_BUTTON.get(), ACBlocks.CORK_PLANKS.get());
        this.trapdoorWithItem(ACBlocks.CORK_TRAPDOOR.get(), (Block)ACBlocks.CORK_TRAPDOOR.get());
        this.signBlock(ACBlocks.CORK_SIGN.get(), ACBlocks.CORK_WALL_SIGN.get(), ArtsAndCrafts.id("block/cork_planks"));
        this.hangingSignBlock((Block)ACBlocks.CORK_HANGING_SIGN.get(), (Block)ACBlocks.CORK_WALL_HANGING_SIGN.get(), "cork");
        this.normalFlowerPotBlock((Block)ACBlocks.POTTED_CORK_SAPLING.get(), "cork_sapling", "arts_and_crafts");
        this.lotusFlowerBlock(ACBlocks.LOTUS_FLOWER.get());
        for (DyeColor colours : DyeColor.values()) {
            this.plasterWithItem(ACBlocks.getDyedPlaster(colours.getId()), colours);
            this.plasterWithItem((Block)ACBlocks.PLASTER.get(), null);
            this.chalkDustBlock(ACBlocks.getChalkDust(colours.getId()), colours.getName());
            this.cubeAllWithItem(ACBlocks.getChalk(colours.getId()));
            this.cubeAllWithItem(ACBlocks.getDyedTerracottaShingles(colours.getId()));
            this.stairsWithItem((StairBlock)ACBlocks.getDyedTerracottaShingleStairs(colours.getId()), ACBlocks.getDyedTerracottaShingles(colours.getId()));
            this.slabWithItem((SlabBlock)ACBlocks.getDyedTerracottaShingleSlab(colours.getId()), ACBlocks.getDyedTerracottaShingles(colours.getId()));
            this.wallWithItem((WallBlock)ACBlocks.getDyedTerracottaShingleWall(colours.getId()), ACBlocks.getDyedTerracottaShingles(colours.getId()));
            this.cubeAllWithItem(ACBlocks.getDyedMudBricks(colours.getId()));
            this.stairsWithItem((StairBlock)ACBlocks.getDyedMudBrickStairs(colours.getId()), ACBlocks.getDyedMudBricks(colours.getId()));
            this.slabWithItem((SlabBlock)ACBlocks.getDyedMudBrickSlab(colours.getId()), ACBlocks.getDyedMudBricks(colours.getId()));
            this.wallWithItem((WallBlock)ACBlocks.getDyedMudBrickWall(colours.getId()), ACBlocks.getDyedMudBricks(colours.getId()));
            this.cubeAllWithItem(ACBlocks.getDyedSoapstone(colours.getId()));
            this.stairsWithItem((StairBlock)ACBlocks.getDyedSoapstoneStairs(colours.getId()), ACBlocks.getDyedSoapstone(colours.getId()));
            this.slabWithItem((SlabBlock)ACBlocks.getDyedSoapstoneSlab(colours.getId()), ACBlocks.getDyedSoapstone(colours.getId()));
            this.wallWithItem((WallBlock)ACBlocks.getDyedSoapstoneWall(colours.getId()), ACBlocks.getDyedSoapstone(colours.getId()));
            this.cubeAllWithItem(ACBlocks.getDyedSoapstoneBricks(colours.getId()));
            this.stairsWithItem((StairBlock)ACBlocks.getDyedSoapstoneBrickStairs(colours.getId()), ACBlocks.getDyedSoapstoneBricks(colours.getId()));
            this.slabWithItem((SlabBlock)ACBlocks.getDyedSoapstoneBrickSlab(colours.getId()), ACBlocks.getDyedSoapstoneBricks(colours.getId()));
            this.wallWithItem((WallBlock)ACBlocks.getDyedSoapstoneBrickWall(colours.getId()), ACBlocks.getDyedSoapstoneBricks(colours.getId()));
            this.cubeAllWithItem(ACBlocks.getDyedPolishedSoapstone(colours.getId()));
            this.stairsWithItem((StairBlock)ACBlocks.getDyedPolishedSoapstoneStairs(colours.getId()), ACBlocks.getDyedPolishedSoapstone(colours.getId()));
            this.slabWithItem((SlabBlock)ACBlocks.getDyedPolishedSoapstoneSlab(colours.getId()), ACBlocks.getDyedPolishedSoapstone(colours.getId()));
            this.wallWithItem((WallBlock)ACBlocks.getDyedPolishedSoapstoneWall(colours.getId()), ACBlocks.getDyedPolishedSoapstone(colours.getId()));
            this.emptyFlowerPotBlock(ACBlocks.getDyedFlowerPot(colours.getId()), colours);
            this.flowerPotBlock(ACBlocks.getDyedPottedCorkSapling(colours), colours, "cork_sapling", "arts_and_crafts");
            this.flowerPotBlock(ACBlocks.getDyedPottedOakSapling(colours), colours, "oak_sapling", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedSpruceSapling(colours), colours, "spruce_sapling", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedBirchSapling(colours), colours, "birch_sapling", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedJungleSapling(colours), colours, "jungle_sapling", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedAcaciaSapling(colours), colours, "acacia_sapling", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedCherrySapling(colours), colours, "cherry_sapling", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedDarkOakSapling(colours), colours, "dark_oak_sapling", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedMangrovePropagule(colours), colours, "mangrove_propagule", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedCrimsonFungus(colours), colours, "crimson_fungus", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedCrimsonRoots(colours), colours, "crimson_roots_pot", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedWarpedFungus(colours), colours, "warped_fungus", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedWarpedRoots(colours), colours, "warped_roots_pot", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedFern(colours), colours, "fern", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedDandelion(colours), colours, "dandelion", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedPoppy(colours), colours, "poppy", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedBlueOrchid(colours), colours, "blue_orchid", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedAllium(colours), colours, "allium", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedAzureBluet(colours), colours, "azure_bluet", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedRedTulip(colours), colours, "red_tulip", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedOrangeTulip(colours), colours, "orange_tulip", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedWhiteTulip(colours), colours, "white_tulip", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedPinkTulip(colours), colours, "pink_tulip", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedOxeyeDaisy(colours), colours, "oxeye_daisy", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedCornflower(colours), colours, "cornflower", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedLilyOfTheValley(colours), colours, "lily_of_the_valley", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedWitherRose(colours), colours, "wither_rose", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedRedMushroom(colours), colours, "red_mushroom", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedBrownMushroom(colours), colours, "brown_mushroom", "minecraft");
            this.flowerPotBlock(ACBlocks.getDyedPottedDeadBush(colours), colours, "dead_bush", "minecraft");
            this.cactusFlowerPotBlock(ACBlocks.getDyedPottedCactus(colours), colours);
            this.bambooFlowerPotBlock(ACBlocks.getDyedPottedBamboo(colours), colours);
            this.azaleaFlowerPotBlock(ACBlocks.getDyedPottedAzalea(colours), colours, "potted_azalea_bush");
            this.azaleaFlowerPotBlock(ACBlocks.getDyedPottedFloweringAzalea(colours), colours, "potted_flowering_azalea_bush");
            this.flowerPotBlock(ACBlocks.getDyedPottedTorchFlower(colours), colours, "torchflower", "minecraft");
        }
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private void cubeAllWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    private void concretePowderWithItem(Block block) {
        this.concretePowderBlock(block);
        this.simpleBlockItem(block, this.cubeAll(block));
    }

    private void glazedTerracottaWithItem(Block block, String blockId) {
        this.glazedTerracotta(block);
        this.simpleBlockItem(block, (ModelFile)this.glazedTerracottaModel(blockId));
    }

    private void bedBlock(Block block, String blockId) {
        this.simpleBlock(block, (ModelFile)this.bedModel(blockId).texture("particle", "minecraft:block/oak_planks"));
    }

    private void stairsWithItem(StairBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.stairsBlock(block, resLoc);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().stairs(this.name((Block)block), resLoc, resLoc, resLoc));
    }

    private void slabWithItem(SlabBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.slabBlock(block, resLoc, resLoc);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().slab(this.name((Block)block), resLoc, resLoc, resLoc));
    }

    private void wallWithItem(WallBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.wallBlock(block, resLoc);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().wallInventory(this.name((Block)block), resLoc));
    }

    private void fenceWithItem(FenceBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.fenceBlock(block, resLoc);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().fenceInventory(this.name((Block)block), resLoc));
    }

    private void fenceGateWithItem(FenceGateBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.fenceGateBlock(block, resLoc);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().fenceGate(this.name((Block)block), resLoc));
    }

    private void pressurePlateWithItem(PressurePlateBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.pressurePlateBlock(block, resLoc);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().pressurePlate(this.name((Block)block), resLoc));
    }

    private void buttonWithItem(ButtonBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.buttonBlock(block, resLoc);
    }

    private void carpetWithItem(Block block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.simpleBlock(block, (ModelFile)this.models().carpet(this.name(block), resLoc));
        this.simpleBlockItem(block, (ModelFile)this.models().carpet(this.name(block), resLoc));
    }

    private void trapdoorWithItem(TrapDoorBlock block, Block blockTexture) {
        ResourceLocation resLoc = this.blockTexture(blockTexture);
        this.trapdoorBlock(block, resLoc, true);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().trapdoorOrientableBottom(this.name((Block)block), resLoc));
    }

    private void hangingSignBlock(Block hangingSignBlock, Block wallHangingSignBlock, String woodType) {
        ModelBuilder sign = this.models().sign(this.name(hangingSignBlock), ArtsAndCrafts.id("block/" + woodType + "_planks"));
        this.simpleBlock(hangingSignBlock, (ModelFile)sign);
        this.simpleBlock(wallHangingSignBlock, (ModelFile)sign);
    }

    private void logWithItem(RotatedPillarBlock block) {
        this.logBlock(block);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().withExistingParent(this.name((Block)block), "minecraft:block/cube_column"));
    }

    public void plasterWithItem(Block block, DyeColor dyeColor) {
        if (dyeColor == null) {
            this.normalPlasterBlock(block);
            this.simpleBlockItem(block, (ModelFile)this.plasterModel("plaster"));
        } else {
            this.plasterBlock(block, dyeColor);
            this.simpleBlockItem(block, (ModelFile)this.plasterModel(dyeColor.getName() + "_plaster"));
        }
    }

    public void azaleaFlowerPotBlock(Block block, DyeColor dyeColor, String flower) {
        if (flower.equals("potted_azalea_bush")) {
            this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)this.azaleaFlowerPotModel(dyeColor.getName() + "_potted_" + flower).texture("particle", "block/" + dyeColor.getName() + "_flower_pot").texture("flowerpot", "block/" + dyeColor.getName() + "_flower_pot")).build());
        }
        if (flower.equals("potted_flowering_azalea_bush")) {
            this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)this.floweringAzaleaFlowerPotModel(dyeColor.getName() + "_potted_" + flower).texture("particle", "block/" + dyeColor.getName() + "_flower_pot").texture("flowerpot", "block/" + dyeColor.getName() + "_flower_pot")).build());
        }
    }

    public void cactusFlowerPotBlock(Block block, DyeColor dyeColor) {
        this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)this.cactusFlowerPotModel(dyeColor.getName() + "_potted_cactus").texture("particle", "block/" + dyeColor.getName() + "_flower_pot").texture("flowerpot", "block/" + dyeColor.getName() + "_flower_pot")).build());
    }

    public void bambooFlowerPotBlock(Block block, DyeColor dyeColor) {
        this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)this.bambooFlowerPotModel(dyeColor.getName() + "_potted_bamboo").texture("particle", "block/" + dyeColor.getName() + "_flower_pot").texture("flowerpot", "block/" + dyeColor.getName() + "_flower_pot")).build());
    }

    public void emptyFlowerPotBlock(Block block, DyeColor dyeColor) {
        this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)this.flowerPotModel(dyeColor.getName() + "_flower_pot").texture("particle", "block/" + dyeColor.getName() + "_flower_pot").texture("flowerpot", "block/" + dyeColor.getName() + "_flower_pot")).build());
    }

    public void flowerPotBlock(Block block, DyeColor dyeColor, String flower, String modId) {
        this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)this.flowerPotCrossModel(dyeColor.getName() + "_potted_" + flower).texture("plant", modId + ":block/" + flower).texture("particle", "block/" + dyeColor.getName() + "_flower_pot").texture("flowerpot", "block/" + dyeColor.getName() + "_flower_pot")).build());
    }

    public void normalFlowerPotBlock(Block block, String flower, String modId) {
        this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)this.flowerPotCrossModel("potted_" + flower).texture("plant", modId + ":block/" + flower)).build());
    }

    public void lotusFlowerBlock(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_0").texture("lotus", "block/lotus_0").texture("particle", "block/lotus_0")).rotationY(180).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_1").texture("lotus", "block/lotus_1").texture("particle", "block/lotus_1")).rotationY(180).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_2").texture("lotus", "block/lotus_2").texture("particle", "block/lotus_2")).rotationY(180).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_3").texture("lotus", "block/lotus_3").texture("particle", "block/lotus_3")).rotationY(180).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_0").texture("lotus", "block/lotus_0").texture("particle", "block/lotus_0")).rotationY(270).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_1").texture("lotus", "block/lotus_1").texture("particle", "block/lotus_1")).rotationY(270).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_2").texture("lotus", "block/lotus_2").texture("particle", "block/lotus_2")).rotationY(270).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_3").texture("lotus", "block/lotus_3").texture("particle", "block/lotus_3")).rotationY(270).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_0").texture("lotus", "block/lotus_0").texture("particle", "block/lotus_0")).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_1").texture("lotus", "block/lotus_1").texture("particle", "block/lotus_1")).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_2").texture("lotus", "block/lotus_2").texture("particle", "block/lotus_2")).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_3").texture("lotus", "block/lotus_3").texture("particle", "block/lotus_3")).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_0").texture("lotus", "block/lotus_0").texture("particle", "block/lotus_0")).rotationY(90).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_1").texture("lotus", "block/lotus_1").texture("particle", "block/lotus_1")).rotationY(90).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_2").texture("lotus", "block/lotus_2").texture("particle", "block/lotus_2")).rotationY(90).build()).partialState().with((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.lotusFlowerModel("lotus_flower_3").texture("lotus", "block/lotus_3").texture("particle", "block/lotus_3")).rotationY(90).build());
    }

    public void glazedTerracotta(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.glazedTerracottaModel(this.name(block)).texture("pattern", "block/" + this.name(block))).rotationY(180).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.glazedTerracottaModel(this.name(block)).texture("pattern", "block/" + this.name(block))).rotationY(270).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.glazedTerracottaModel(this.name(block)).texture("pattern", "block/" + this.name(block))).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.glazedTerracottaModel(this.name(block)).texture("pattern", "block/" + this.name(block))).rotationY(90).build());
    }

    public void concretePowderBlock(Block block) {
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.cubeAllModel(this.name(block)).texture("all", "block/" + this.name(block))).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.cubeAllModel(this.name(block)).texture("all", "block/" + this.name(block))).rotationY(90).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.cubeAllModel(this.name(block)).texture("all", "block/" + this.name(block))).rotationY(180).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.cubeAllModel(this.name(block)).texture("all", "block/" + this.name(block))).rotationY(270).build());
    }

    public void normalPlasterBlock(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel("plaster").texture("plaster", "block/plaster").texture("particle", "block/plaster")).rotationY(180).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel("plaster").texture("plaster", "block/plaster").texture("particle", "block/plaster")).rotationY(270).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel("plaster").texture("plaster", "block/plaster").texture("particle", "block/plaster")).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel("plaster").texture("plaster", "block/plaster").texture("particle", "block/plaster")).rotationY(90).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel("plaster").texture("plaster", "block/plaster").texture("particle", "block/plaster")).rotationX(90).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel("plaster").texture("plaster", "block/plaster").texture("particle", "block/plaster")).rotationX(270).build());
    }

    public void plasterBlock(Block block, DyeColor dyeColor) {
        this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel(dyeColor.getName() + "_plaster").texture("plaster", "block/" + dyeColor.getName() + "_plaster").texture("particle", "block/" + dyeColor.getName() + "_plaster")).rotationY(180).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel(dyeColor.getName() + "_plaster").texture("plaster", "block/" + dyeColor.getName() + "_plaster").texture("particle", "block/" + dyeColor.getName() + "_plaster")).rotationY(270).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel(dyeColor.getName() + "_plaster").texture("plaster", "block/" + dyeColor.getName() + "_plaster").texture("particle", "block/" + dyeColor.getName() + "_plaster")).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel(dyeColor.getName() + "_plaster").texture("plaster", "block/" + dyeColor.getName() + "_plaster").texture("particle", "block/" + dyeColor.getName() + "_plaster")).rotationY(90).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel(dyeColor.getName() + "_plaster").texture("plaster", "block/" + dyeColor.getName() + "_plaster").texture("particle", "block/" + dyeColor.getName() + "_plaster")).rotationX(90).build()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.plasterModel(dyeColor.getName() + "_plaster").texture("plaster", "block/" + dyeColor.getName() + "_plaster").texture("particle", "block/" + dyeColor.getName() + "_plaster")).rotationX(270).build());
    }

    public void chalkDustBlock(Block block, String dyeColor) {
        String dot = "block/" + dyeColor + "_dot";
        String verticalLine = "block/" + dyeColor + "_vertical_line_middle";
        String rotatedLine = "block/" + dyeColor + "_rotated_line_middle";
        String corner0 = "block/" + dyeColor + "_corner_0";
        String corner1 = "block/" + dyeColor + "_corner_1";
        String corner2 = "block/" + dyeColor + "_corner_2";
        String corner3 = "block/" + dyeColor + "_corner_3";
        String tCross0 = "block/" + dyeColor + "_t_cross_0";
        String tCross1 = "block/" + dyeColor + "_t_cross_1";
        String tCross2 = "block/" + dyeColor + "_t_cross_2";
        String tCross3 = "block/" + dyeColor + "_t_cross_3";
        String plus = "block/" + dyeColor + "_plus";
        String diagonalLineRight = "block/" + dyeColor + "_diagonal_line_right";
        String diagonalLineLeft = "block/" + dyeColor + "_diagonal_line_left";
        String x = "block/" + dyeColor + "_x";
        String lineEdge0 = "block/" + dyeColor + "_line_edge_0";
        String lineEdge1 = "block/" + dyeColor + "_line_edge_1";
        String lineEdge2 = "block/" + dyeColor + "_line_edge_2";
        String lineEdge3 = "block/" + dyeColor + "_line_edge_3";
        String triangle0 = "block/" + dyeColor + "_triangle_0";
        String triangle1 = "block/" + dyeColor + "_triangle_1";
        String triangle2 = "block/" + dyeColor + "_triangle_2";
        String triangle3 = "block/" + dyeColor + "_triangle_3";
        String circle = "block/" + dyeColor + "_circle";
        String square = "block/" + dyeColor + "_square";
        String blockCorner0 = "block/" + dyeColor + "_block_corner_0";
        String blockCorner1 = "block/" + dyeColor + "_block_corner_1";
        String blockCorner2 = "block/" + dyeColor + "_block_corner_2";
        String blockCorner3 = "block/" + dyeColor + "_block_corner_3";
        String arch0 = "block/" + dyeColor + "_arch_0";
        String arch1 = "block/" + dyeColor + "_arch_1";
        String arch2 = "block/" + dyeColor + "_arch_2";
        String arch3 = "block/" + dyeColor + "_arch_3";
        this.getVariantBuilder(block).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_dot").texture("dust", dot).texture("particle", dot)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_dot").texture("dust", dot).texture("particle", dot)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_dot").texture("dust", dot).texture("particle", dot)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_dot").texture("dust", dot).texture("particle", dot)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_dot").texture("dust", dot).texture("particle", dot)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(0)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_dot").texture("dust", dot).texture("particle", dot)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_vertical_line_middle").texture("dust", verticalLine).texture("particle", verticalLine)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_vertical_line_middle").texture("dust", verticalLine).texture("particle", verticalLine)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_vertical_line_middle").texture("dust", verticalLine).texture("particle", verticalLine)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_vertical_line_middle").texture("dust", verticalLine).texture("particle", verticalLine)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_vertical_line_middle").texture("dust", verticalLine).texture("particle", verticalLine)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(1)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_vertical_line_middle").texture("dust", verticalLine).texture("particle", verticalLine)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_rotated_line_middle").texture("dust", rotatedLine).texture("particle", rotatedLine)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_rotated_line_middle").texture("dust", rotatedLine).texture("particle", rotatedLine)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_rotated_line_middle").texture("dust", rotatedLine).texture("particle", rotatedLine)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_rotated_line_middle").texture("dust", rotatedLine).texture("particle", rotatedLine)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_rotated_line_middle").texture("dust", rotatedLine).texture("particle", rotatedLine)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(2)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_rotated_line_middle").texture("dust", rotatedLine).texture("particle", rotatedLine)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_0").texture("dust", corner0).texture("particle", corner0)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_0").texture("dust", corner0).texture("particle", corner0)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_0").texture("dust", corner0).texture("particle", corner0)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_0").texture("dust", corner0).texture("particle", corner0)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_0").texture("dust", corner0).texture("particle", corner0)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(3)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_0").texture("dust", corner0).texture("particle", corner0)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(4)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_1").texture("dust", corner1).texture("particle", corner1)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(4)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_1").texture("dust", corner1).texture("particle", corner1)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(4)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_1").texture("dust", corner1).texture("particle", corner1)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(4)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_1").texture("dust", corner1).texture("particle", corner1)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(4)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_1").texture("dust", corner1).texture("particle", corner1)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(4)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_1").texture("dust", corner1).texture("particle", corner1)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(5)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_2").texture("dust", corner2).texture("particle", corner2)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(5)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_2").texture("dust", corner2).texture("particle", corner2)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(5)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_2").texture("dust", corner2).texture("particle", corner2)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(5)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_2").texture("dust", corner2).texture("particle", corner2)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(5)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_2").texture("dust", corner2).texture("particle", corner2)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(5)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_2").texture("dust", corner2).texture("particle", corner2)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(6)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_3").texture("dust", corner3).texture("particle", corner3)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(6)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_3").texture("dust", corner3).texture("particle", corner3)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(6)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_3").texture("dust", corner3).texture("particle", corner3)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(6)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_3").texture("dust", corner3).texture("particle", corner3)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(6)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_3").texture("dust", corner3).texture("particle", corner3)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(6)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_corner_3").texture("dust", corner3).texture("particle", corner3)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(7)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_0").texture("dust", tCross0).texture("particle", tCross0)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(7)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_0").texture("dust", tCross0).texture("particle", tCross0)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(7)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_0").texture("dust", tCross0).texture("particle", tCross0)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(7)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_0").texture("dust", tCross0).texture("particle", tCross0)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(7)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_0").texture("dust", tCross0).texture("particle", tCross0)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(7)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_0").texture("dust", tCross0).texture("particle", tCross0)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(8)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_1").texture("dust", tCross1).texture("particle", tCross1)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(8)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_1").texture("dust", tCross1).texture("particle", tCross1)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(8)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_1").texture("dust", tCross1).texture("particle", tCross1)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(8)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_1").texture("dust", tCross1).texture("particle", tCross1)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(8)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_1").texture("dust", tCross1).texture("particle", tCross1)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(8)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_1").texture("dust", tCross1).texture("particle", tCross1)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(9)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_2").texture("dust", tCross2).texture("particle", tCross2)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(9)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_2").texture("dust", tCross2).texture("particle", tCross2)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(9)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_2").texture("dust", tCross2).texture("particle", tCross2)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(9)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_2").texture("dust", tCross2).texture("particle", tCross2)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(9)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_2").texture("dust", tCross2).texture("particle", tCross2)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(9)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_2").texture("dust", tCross2).texture("particle", tCross2)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(10)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_3").texture("dust", tCross3).texture("particle", tCross3)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(10)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_3").texture("dust", tCross3).texture("particle", tCross3)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(10)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_3").texture("dust", tCross3).texture("particle", tCross3)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(10)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_3").texture("dust", tCross3).texture("particle", tCross3)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(10)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_3").texture("dust", tCross3).texture("particle", tCross3)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(10)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_t_cross_3").texture("dust", tCross3).texture("particle", tCross3)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(11)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_plus").texture("dust", plus).texture("particle", plus)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(11)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_plus").texture("dust", plus).texture("particle", plus)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(11)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_plus").texture("dust", plus).texture("particle", plus)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(11)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_plus").texture("dust", plus).texture("particle", plus)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(11)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_plus").texture("dust", plus).texture("particle", plus)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(11)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_plus").texture("dust", plus).texture("particle", plus)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(12)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_right").texture("dust", diagonalLineRight).texture("particle", diagonalLineRight)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(12)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_right").texture("dust", diagonalLineRight).texture("particle", diagonalLineRight)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(12)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_right").texture("dust", diagonalLineRight).texture("particle", diagonalLineRight)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(12)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_right").texture("dust", diagonalLineRight).texture("particle", diagonalLineRight)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(12)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_right").texture("dust", diagonalLineRight).texture("particle", diagonalLineRight)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(12)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_right").texture("dust", diagonalLineRight).texture("particle", diagonalLineRight)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(13)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_left").texture("dust", diagonalLineLeft).texture("particle", diagonalLineLeft)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(13)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_left").texture("dust", diagonalLineLeft).texture("particle", diagonalLineLeft)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(13)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_left").texture("dust", diagonalLineLeft).texture("particle", diagonalLineLeft)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(13)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_left").texture("dust", diagonalLineLeft).texture("particle", diagonalLineLeft)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(13)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_left").texture("dust", diagonalLineLeft).texture("particle", diagonalLineLeft)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(13)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_diagonal_line_left").texture("dust", diagonalLineLeft).texture("particle", diagonalLineLeft)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(14)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_x").texture("dust", x).texture("particle", x)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(14)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_x").texture("dust", x).texture("particle", x)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(14)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_x").texture("dust", x).texture("particle", x)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(14)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_x").texture("dust", x).texture("particle", x)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(14)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_x").texture("dust", x).texture("particle", x)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(14)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_x").texture("dust", x).texture("particle", x)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(15)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_0").texture("dust", lineEdge0).texture("particle", lineEdge0)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(15)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_0").texture("dust", lineEdge0).texture("particle", lineEdge0)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(15)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_0").texture("dust", lineEdge0).texture("particle", lineEdge0)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(15)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_0").texture("dust", lineEdge0).texture("particle", lineEdge0)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(15)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_0").texture("dust", lineEdge0).texture("particle", lineEdge0)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(15)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_0").texture("dust", lineEdge0).texture("particle", lineEdge0)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(16)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_1").texture("dust", lineEdge1).texture("particle", lineEdge1)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(16)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_1").texture("dust", lineEdge1).texture("particle", lineEdge1)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(16)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_1").texture("dust", lineEdge1).texture("particle", lineEdge1)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(16)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_1").texture("dust", lineEdge1).texture("particle", lineEdge1)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(16)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_1").texture("dust", lineEdge1).texture("particle", lineEdge1)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(16)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_1").texture("dust", lineEdge1).texture("particle", lineEdge1)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(17)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_2").texture("dust", lineEdge2).texture("particle", lineEdge2)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(17)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_2").texture("dust", lineEdge2).texture("particle", lineEdge2)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(17)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_2").texture("dust", lineEdge2).texture("particle", lineEdge2)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(17)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_2").texture("dust", lineEdge2).texture("particle", lineEdge2)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(17)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_2").texture("dust", lineEdge2).texture("particle", lineEdge2)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(17)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_2").texture("dust", lineEdge2).texture("particle", lineEdge2)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(18)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_3").texture("dust", lineEdge3).texture("particle", lineEdge3)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(18)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_3").texture("dust", lineEdge3).texture("particle", lineEdge3)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(18)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_3").texture("dust", lineEdge3).texture("particle", lineEdge3)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(18)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_3").texture("dust", lineEdge3).texture("particle", lineEdge3)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(18)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_3").texture("dust", lineEdge3).texture("particle", lineEdge3)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(18)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_line_edge_3").texture("dust", lineEdge3).texture("particle", lineEdge3)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(19)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_0").texture("dust", triangle0).texture("particle", triangle0)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(19)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_0").texture("dust", triangle0).texture("particle", triangle0)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(19)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_0").texture("dust", triangle0).texture("particle", triangle0)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(19)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_0").texture("dust", triangle0).texture("particle", triangle0)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(19)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_0").texture("dust", triangle0).texture("particle", triangle0)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(19)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_0").texture("dust", triangle0).texture("particle", triangle0)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(20)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_1").texture("dust", triangle1).texture("particle", triangle1)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(20)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_1").texture("dust", triangle1).texture("particle", triangle1)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(20)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_1").texture("dust", triangle1).texture("particle", triangle1)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(20)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_1").texture("dust", triangle1).texture("particle", triangle1)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(20)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_1").texture("dust", triangle1).texture("particle", triangle1)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(20)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_1").texture("dust", triangle1).texture("particle", triangle1)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(21)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_2").texture("dust", triangle2).texture("particle", triangle2)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(21)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_2").texture("dust", triangle2).texture("particle", triangle2)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(21)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_2").texture("dust", triangle2).texture("particle", triangle2)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(21)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_2").texture("dust", triangle2).texture("particle", triangle2)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(21)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_2").texture("dust", triangle2).texture("particle", triangle2)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(21)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_2").texture("dust", triangle2).texture("particle", triangle2)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(22)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_3").texture("dust", triangle3).texture("particle", triangle3)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(22)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_3").texture("dust", triangle3).texture("particle", triangle3)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(22)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_3").texture("dust", triangle3).texture("particle", triangle3)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(22)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_3").texture("dust", triangle3).texture("particle", triangle3)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(22)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_3").texture("dust", triangle3).texture("particle", triangle3)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(22)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_triangle_3").texture("dust", triangle3).texture("particle", triangle3)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(23)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_circle").texture("dust", circle).texture("particle", circle)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(23)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_circle").texture("dust", circle).texture("particle", circle)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(23)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_circle").texture("dust", circle).texture("particle", circle)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(23)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_circle").texture("dust", circle).texture("particle", circle)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(23)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_circle").texture("dust", circle).texture("particle", circle)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(23)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_circle").texture("dust", circle).texture("particle", circle)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(24)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_square").texture("dust", square).texture("particle", square)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(24)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_square").texture("dust", square).texture("particle", square)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(24)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_square").texture("dust", square).texture("particle", square)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(24)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_square").texture("dust", square).texture("particle", square)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(24)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_square").texture("dust", square).texture("particle", square)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(24)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_square").texture("dust", square).texture("particle", square)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(25)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_0").texture("dust", blockCorner0).texture("particle", blockCorner0)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(25)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_0").texture("dust", blockCorner0).texture("particle", blockCorner0)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(25)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_0").texture("dust", blockCorner0).texture("particle", blockCorner0)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(25)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_0").texture("dust", blockCorner0).texture("particle", blockCorner0)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(25)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_0").texture("dust", blockCorner0).texture("particle", blockCorner0)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(25)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_0").texture("dust", blockCorner0).texture("particle", blockCorner0)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(26)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_1").texture("dust", blockCorner1).texture("particle", blockCorner1)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(26)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_1").texture("dust", blockCorner1).texture("particle", blockCorner1)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(26)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_1").texture("dust", blockCorner1).texture("particle", blockCorner1)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(26)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_1").texture("dust", blockCorner1).texture("particle", blockCorner1)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(26)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_1").texture("dust", blockCorner1).texture("particle", blockCorner1)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(26)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_1").texture("dust", blockCorner1).texture("particle", blockCorner1)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(27)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_2").texture("dust", blockCorner2).texture("particle", blockCorner2)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(27)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_2").texture("dust", blockCorner2).texture("particle", blockCorner2)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(27)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_2").texture("dust", blockCorner2).texture("particle", blockCorner2)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(27)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_2").texture("dust", blockCorner2).texture("particle", blockCorner2)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(27)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_2").texture("dust", blockCorner2).texture("particle", blockCorner2)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(27)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_2").texture("dust", blockCorner2).texture("particle", blockCorner2)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(28)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_3").texture("dust", blockCorner3).texture("particle", blockCorner3)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(28)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_3").texture("dust", blockCorner3).texture("particle", blockCorner3)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(28)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_3").texture("dust", blockCorner3).texture("particle", blockCorner3)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(28)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_3").texture("dust", blockCorner3).texture("particle", blockCorner3)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(28)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_3").texture("dust", blockCorner3).texture("particle", blockCorner3)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(28)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_block_corner_3").texture("dust", blockCorner3).texture("particle", blockCorner3)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(29)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_0").texture("dust", arch0).texture("particle", arch0)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(29)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_0").texture("dust", arch0).texture("particle", arch0)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(29)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_0").texture("dust", arch0).texture("particle", arch0)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(29)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_0").texture("dust", arch0).texture("particle", arch0)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(29)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_0").texture("dust", arch0).texture("particle", arch0)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(29)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_0").texture("dust", arch0).texture("particle", arch0)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(30)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_1").texture("dust", arch1).texture("particle", arch1)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(30)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_1").texture("dust", arch1).texture("particle", arch1)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(30)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_1").texture("dust", arch1).texture("particle", arch1)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(30)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_1").texture("dust", arch1).texture("particle", arch1)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(30)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_1").texture("dust", arch1).texture("particle", arch1)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(30)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_1").texture("dust", arch1).texture("particle", arch1)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(31)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_2").texture("dust", arch2).texture("particle", arch2)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(31)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_2").texture("dust", arch2).texture("particle", arch2)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(31)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_2").texture("dust", arch2).texture("particle", arch2)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(31)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_2").texture("dust", arch2).texture("particle", arch2)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(31)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_2").texture("dust", arch2).texture("particle", arch2)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(31)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_2").texture("dust", arch2).texture("particle", arch2)).rotationX(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(32)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_3").texture("dust", arch3).texture("particle", arch3)).rotationY(180).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(32)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_3").texture("dust", arch3).texture("particle", arch3)).rotationY(270).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(32)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_3").texture("dust", arch3).texture("particle", arch3)).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(32)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_3").texture("dust", arch3).texture("particle", arch3)).rotationY(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(32)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_3").texture("dust", arch3).texture("particle", arch3)).rotationX(90).build()).partialState().with((Property)ACBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(32)).with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).addModels(ConfiguredModel.builder().modelFile((ModelFile)this.chalkDustModel(dyeColor + "_arch_3").texture("dust", arch3).texture("particle", arch3)).rotationX(270).build());
    }

    public ModelBuilder<?> chalkDustModel(String name) {
        return this.models().withExistingParent(name, "arts_and_crafts:block/chalk_dust");
    }

    public ModelBuilder<?> plasterModel(String name) {
        return this.models().withExistingParent(name, "arts_and_crafts:block/plaster_model");
    }

    public ModelBuilder<?> lotusFlowerModel(String name) {
        return this.models().withExistingParent(name, "arts_and_crafts:block/lotus_flower_model");
    }

    public ModelBuilder<?> glazedTerracottaModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/template_glazed_terracotta");
    }

    public ModelBuilder<?> flowerPotModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/flower_pot");
    }

    public ModelBuilder<?> cubeAllModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/cube_all");
    }

    public ModelBuilder<?> flowerPotCrossModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/flower_pot_cross");
    }

    public ModelBuilder<?> cactusFlowerPotModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/potted_cactus");
    }

    public ModelBuilder<?> bambooFlowerPotModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/potted_bamboo");
    }

    public ModelBuilder<?> azaleaFlowerPotModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/potted_azalea_bush");
    }

    public ModelBuilder<?> floweringAzaleaFlowerPotModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/potted_flowering_azalea_bush");
    }

    public ModelBuilder<?> bedModel(String name) {
        return this.models().withExistingParent(name, "minecraft:block/bed");
    }
}

