/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.item;

import com.kekecreations.arts_and_crafts.common.util.ACTags;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class LotusPistilItem
extends Item {
    public LotusPistilItem(Item.Properties $$0) {
        super($$0);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (!level.isClientSide()) {
            InteractionResult interactionResult = this.place(new BlockPlaceContext(useOnContext));
            return interactionResult;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult place(BlockPlaceContext blockPlaceContext) {
        BlockState state;
        Level level = blockPlaceContext.getLevel();
        BlockPos pos = blockPlaceContext.getClickedPos().below();
        Player player = blockPlaceContext.getPlayer();
        ItemStack itemStack = blockPlaceContext.getItemInHand();
        RandomSource randomSource = level.getRandom();
        BlockState clickedState = level.getBlockState(pos);
        if (clickedState.is(ACTags.BlockTags.LILY_PADS) && (state = ACBlocks.LOTUS_FLOWER.get().getStateForPlacement(blockPlaceContext)) != null) {
            level.setBlockAndUpdate(pos, state);
            level.playSound(null, pos, SoundEvents.LILY_PAD_PLACE, SoundSource.BLOCKS, 0.5f, randomSource.nextFloat() * 0.2f + 0.9f);
            level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)clickedState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, itemStack);
            }
            clickedState.getBlock().setPlacedBy(level, pos, clickedState, (LivingEntity)player, itemStack);
            if (player != null && !player.getAbilities().instabuild) {
                itemStack.setCount(itemStack.getCount() - 1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

