/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.common.misc.ACBlockStateProperties;
import com.kekecreations.arts_and_crafts.core.registry.ACDataComponents;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChalkDustBlock
extends DirectionalBlock {
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    public static final BooleanProperty GLOW;
    private final Integer dyeColor;
    public static final int MAX_STATE = 32;
    public static final IntegerProperty CHALK_DUST_STATES;
    public static final MapCodec<ChalkDustBlock> CODEC;

    public int getDyeColor() {
        return this.dyeColor;
    }

    public ChalkDustBlock(Integer dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getChalkDustProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)GLOW, (Comparable)Boolean.valueOf(false)));
        this.dyeColor = dyeColor;
    }

    protected IntegerProperty getChalkDustProperty() {
        return CHALK_DUST_STATES;
    }

    public int getMaxState() {
        return 32;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!level.isClientSide() && !((Boolean)blockState.getValue((Property)GLOW)).booleanValue() && itemStack.is(Items.GLOW_INK_SAC)) {
            level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)GLOW, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                itemStack.setCount(itemStack.getCount() - 1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        return ItemInteractionResult.FAIL;
    }

    public int getChalkDustStates(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.getChalkDustProperty());
    }

    public final boolean isMaxState(BlockState blockState) {
        return this.getChalkDustStates(blockState) >= this.getMaxState();
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        ItemStack itemStack = new ItemStack((ItemLike)ACItems.getChalkStick(this.dyeColor));
        if (itemStack.has(ACDataComponents.CHALK_PATTERN.get()) && Screen.hasControlDown()) {
            itemStack.set(ACDataComponents.CHALK_PATTERN.get(), (Object)this.getChalkDustStates(blockState));
        }
        return itemStack;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CHALK_DUST_STATES});
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{GLOW});
    }

    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state);
    }

    public static boolean canAttachTo(BlockGetter p_153830_, Direction p_153831_, BlockPos p_153832_, BlockState p_153833_) {
        return Block.isFaceFull((VoxelShape)p_153833_.getBlockSupportShape(p_153830_, p_153832_), (Direction)p_153831_.getOpposite()) || Block.isFaceFull((VoxelShape)p_153833_.getCollisionShape(p_153830_, p_153832_), (Direction)p_153831_.getOpposite());
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction);
        return ChalkDustBlock.canAttachTo((BlockGetter)level, direction, blockpos, level.getBlockState(blockpos));
    }

    public boolean isValidStateForPlacement(BlockGetter p_221572_, BlockState p_221573_, BlockPos p_221574_, Direction p_221575_) {
        if (!p_221573_.is((Block)this)) {
            BlockPos blockpos = p_221574_.relative(p_221575_);
            return ChalkDustBlock.canAttachTo(p_221572_, p_221575_, blockpos, p_221572_.getBlockState(blockpos));
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.getLevel();
        BlockPos blockpos = blockPlaceContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        return Arrays.stream(blockPlaceContext.getNearestLookingDirections()).map(p_153865_ -> this.getStateForPlacement(blockstate, (BlockGetter)level, blockpos, (Direction)p_153865_)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public BlockState getStateForPlacement(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        if (!this.isValidStateForPlacement(level, blockState, blockPos, direction) || blockState.is((Block)this)) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite());
    }

    public boolean canBeReplaced(BlockState p_153848_, BlockPlaceContext p_153849_) {
        return true;
    }

    public VoxelShape getShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.DOWN -> DOWN_AABB;
            case Direction.UP -> UP_AABB;
        };
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == ((Direction)state.getValue((Property)FACING)).getOpposite() && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    static {
        CHALK_DUST_STATES = ACBlockStateProperties.CHALK_PATTERN;
        CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)Codec.INT.fieldOf("dyecolor").forGetter($$0x -> $$0x.dyeColor), (App)ChalkDustBlock.propertiesCodec()).apply((Applicative)$$0, ChalkDustBlock::new));
        GLOW = BooleanProperty.create((String)"glow");
    }
}

