/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.scissor.ScissorBoxStack;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;

public final class RenderUtils {
    private RenderUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static Rect2i getScissorRect(Minecraft minecraft, PoseStack stack, int x, int y, int width, int height) {
        float guiScale = (float)minecraft.getWindow().getGuiScale();
        Vector2ic translation = RenderUtils.getTranslation(stack);
        float translationX = (float)translation.x() * guiScale;
        float translationY = (float)translation.y() * guiScale;
        return new Rect2i((int)(translationX + (float)x * guiScale), (int)((float)Minecraft.getInstance().getWindow().getHeight() - (float)y * guiScale - translationY - (float)height * guiScale), (int)((float)width * guiScale), (int)((float)height * guiScale));
    }

    public static Vector2ic getTranslation(PoseStack stack) {
        Matrix4f pose = stack.last().pose();
        Vector3f vec = pose.getTranslation(new Vector3f());
        return new Vector2i((int)vec.x, (int)vec.y);
    }

    public static ClosingScissorBox createScissorBox(Minecraft minecraft, PoseStack stack, int x, int y, int width, int height) {
        Rect2i bound = RenderUtils.getScissorRect(minecraft, stack, x, y, width, height);
        return new ClosingScissorBox(bound.getX(), bound.getY(), bound.getWidth(), bound.getHeight());
    }

    public static CloseableScissorStack createScissorBoxStack(ScissorBoxStack scissorStack, Minecraft minecraft, PoseStack stack, int x, int y, int width, int height) {
        Rect2i bound = RenderUtils.getScissorRect(minecraft, stack, x, y, width, height);
        return new CloseableScissorStack(scissorStack, bound.getX(), bound.getY(), bound.getWidth(), bound.getHeight());
    }

    public static CloseableScissorStack createScissor(Minecraft minecraft, GuiGraphics graphics, int x, int y, int width, int height) {
        Rect2i bound = RenderUtils.getScissorRect(minecraft, graphics.pose(), x, y, width, height);
        return new CloseableScissorStack(new ScissorBoxStack(), bound.getX(), bound.getY(), bound.getWidth(), bound.getHeight());
    }
}

