/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.tiles;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.tiles.base.IHasHUDInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ResearchingTableTile
extends BlockEntity
implements IHasHUDInfo {
    private ItemStack stack = ItemStack.EMPTY;
    public int ticksExisted;

    public ResearchingTableTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.RESEARCHING_TABLE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ResearchingTableTile tile) {
        if (level == null) {
            return;
        }
        ++tile.ticksExisted;
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("stack"));
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.stack != null && !this.stack.isEmpty()) {
            compound.put("stack", this.stack.save(provider, (Tag)new CompoundTag()));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDInfo(PoseStack poseStack, Window window) {
        Minecraft MC = Minecraft.getInstance();
        LocalPlayer player = MC.player;
        GuiGraphics gui = new GuiGraphics(MC, MC.renderBuffers().bufferSource());
        if (player == null) {
            return;
        }
        TextureManager manager = MC.getTextureManager();
        int scale = 2;
        if (!this.stack.isEmpty()) {
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/info/crouch_rmb.png");
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.enableBlend();
            poseStack.pushPose();
            int width = 99;
            int height = 20;
            int x = window.getGuiScaledWidth() / 2 - width / 2 / scale;
            int y = window.getGuiScaledHeight() / 2 + 10;
            manager.bindForSetup(texture);
            gui.blit(texture, x, y, width / scale, height / scale, 0.0f, 0.0f, width, height, width, height);
            poseStack.popPose();
            RenderSystem.disableBlend();
        } else if (player.getMainHandItem().getItem() instanceof IRelicItem) {
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/info/rmb.png");
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.enableBlend();
            poseStack.pushPose();
            int width = 17;
            int height = 20;
            int x = window.getGuiScaledWidth() / 2 - width / 2 / scale;
            int y = window.getGuiScaledHeight() / 2 + 10;
            manager.bindForSetup(texture);
            gui.blit(texture, x, y, width / scale, height / scale, 0.0f, 0.0f, width, height, width, height);
            poseStack.popPose();
            RenderSystem.disableBlend();
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

