/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketRelicTweak
implements CustomPacketPayload {
    private final BlockPos pos;
    private final String ability;
    private final Operation operation;
    public static final CustomPacketPayload.Type<PacketRelicTweak> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"relic_tweak"));
    public static final StreamCodec<ByteBuf, PacketRelicTweak> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketRelicTweak::getPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketRelicTweak::getAbility, (StreamCodec)ByteBufCodecs.idMapper(Operation.BY_ID, Operation::getId), PacketRelicTweak::getOperation, PacketRelicTweak::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Level world = player.level();
            BlockEntity patt0$temp = world.getBlockEntity(this.pos);
            if (!(patt0$temp instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)patt0$temp;
            ItemStack stack = tile.getStack();
            Item patt1$temp = stack.getItem();
            if (!(patt1$temp instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)patt1$temp;
            AbilityData entry = relic.getAbilityData(this.ability);
            if (entry == null) {
                return;
            }
            BlockState state = world.getBlockState(this.pos);
            switch (this.operation.ordinal()) {
                case 1: {
                    if (!relic.mayPlayerUpgrade(player, stack, this.ability)) break;
                    player.giveExperiencePoints(-relic.getUpgradeRequiredExperience(stack, this.ability));
                    relic.setAbilityPoints(stack, this.ability, relic.getAbilityPoints(stack, this.ability) + 1);
                    relic.addPoints(stack, -entry.getRequiredPoints());
                    break;
                }
                case 2: {
                    if (!relic.mayPlayerReroll(player, stack, this.ability)) break;
                    player.giveExperiencePoints(-relic.getRerollRequiredExperience(this.ability));
                    relic.randomizeStats(stack, this.ability);
                    break;
                }
                case 0: {
                    if (!relic.mayPlayerReset(player, stack, this.ability)) break;
                    player.giveExperiencePoints(-relic.getResetRequiredExperience(stack, this.ability));
                    relic.addPoints(stack, relic.getAbilityPoints(stack, this.ability) * entry.getRequiredPoints());
                    relic.setAbilityPoints(stack, this.ability, 0);
                }
            }
            tile.setStack(stack);
            tile.setChanged();
            world.sendBlockUpdated(this.pos, state, world.getBlockState(this.pos), 3);
        });
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getAbility() {
        return this.ability;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketRelicTweak)) {
            return false;
        }
        PacketRelicTweak other = (PacketRelicTweak)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        if (this$ability == null ? other$ability != null : !this$ability.equals(other$ability)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketRelicTweak;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    public String toString() {
        return "PacketRelicTweak(pos=" + String.valueOf(this.getPos()) + ", ability=" + this.getAbility() + ", operation=" + String.valueOf((Object)this.getOperation()) + ")";
    }

    public PacketRelicTweak(BlockPos pos, String ability, Operation operation) {
        this.pos = pos;
        this.ability = ability;
        this.operation = operation;
    }

    public static enum Operation {
        RESET(0),
        INCREASE(1),
        REROLL(2);

        public static final IntFunction<Operation> BY_ID;
        private final int id;

        public int getId() {
            return this.id;
        }

        private Operation(int id) {
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.continuous(Operation::getId, (Object[])Operation.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

