/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketExperienceExchange
implements CustomPacketPayload {
    private final BlockPos pos;
    private final int amount;
    public static final CustomPacketPayload.Type<PacketExperienceExchange> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"experience_exchange"));
    public static final StreamCodec<ByteBuf, PacketExperienceExchange> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketExperienceExchange::getPos, (StreamCodec)ByteBufCodecs.INT, PacketExperienceExchange::getAmount, PacketExperienceExchange::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            int oneCost;
            IRelicItem relic;
            Player player = ctx.player();
            Level world = player.level();
            BlockEntity patt0$temp = world.getBlockEntity(this.pos);
            if (!(patt0$temp instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)patt0$temp;
            ItemStack stack = tile.getStack();
            Item patt1$temp = stack.getItem();
            if (!(patt1$temp instanceof IRelicItem) || (relic = (IRelicItem)patt1$temp).isMaxLevel(stack)) {
                return;
            }
            int playerExperience = EntityUtils.getPlayerTotalExperience(player);
            if (playerExperience <= 0) {
                return;
            }
            int exchanges = relic.getExchanges(stack);
            int level = relic.getLevel(stack);
            int cost = 5;
            int toAdd = 0;
            int toTake = 0;
            for (int i = 0; i < this.amount && playerExperience >= toTake + (oneCost = (int)((float)cost + (float)cost * ((float)(exchanges + i) * 0.01f))); ++i) {
                toAdd += (int)Math.ceil((float)relic.getExperienceBetweenLevels(stack, level, level + 1) / 100.0f);
                toTake += oneCost;
                relic.addExchanges(stack, 1);
            }
            player.giveExperiencePoints(-toTake);
            relic.addExperience((LivingEntity)player, stack, toAdd);
            tile.setChanged();
        });
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketExperienceExchange)) {
            return false;
        }
        PacketExperienceExchange other = (PacketExperienceExchange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketExperienceExchange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAmount();
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result;
    }

    public String toString() {
        return "PacketExperienceExchange(pos=" + String.valueOf(this.getPos()) + ", amount=" + this.getAmount() + ")";
    }

    public PacketExperienceExchange(BlockPos pos, int amount) {
        this.pos = pos;
        this.amount = amount;
    }
}

