/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    protected void init(Item.Properties properties, CallbackInfo ci) {
        Item item = (Item)this;
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            RelicStorage.RELICS.put(relic, relic.getRelicData());
        }
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected, CallbackInfo ci) {
        Object object;
        if (level.isClientSide() || !((object = stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)object;
        for (Map.Entry entry : relic.getRelicData().getAbilities().getAbilities().entrySet()) {
            String ability = (String)entry.getKey();
            if (relic.getAbilityCooldown(stack, ability) <= 0) continue;
            relic.addAbilityCooldown(stack, ability, -1);
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag, CallbackInfo ci) {
        this.relics$processTooltip(stack, context, tooltip);
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private void relics$processTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        LocalPlayer player = Minecraft.getInstance().player;
        tooltip.add((Component)Component.literal((String)" "));
        if (relic.isItemResearched((Player)player)) {
            if (Screen.hasShiftDown()) {
                RelicData relicData = relic.getRelicData();
                if (relicData == null) {
                    return;
                }
                Map<String, AbilityData> abilities = relicData.getAbilities().getAbilities();
                tooltip.add((Component)Component.literal((String)"\u25b6 ").withStyle(ChatFormatting.DARK_GREEN).append((Component)Component.translatable((String)"tooltip.relics.relic.tooltip.abilities").withStyle(ChatFormatting.GREEN)));
                for (Map.Entry<String, AbilityData> entry : abilities.entrySet()) {
                    String id = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
                    String name = entry.getKey();
                    if (!relic.canUseAbility(stack, name)) continue;
                    tooltip.add((Component)Component.literal((String)"   \u25c6 ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)("tooltip.relics." + id + ".ability." + name)).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.WHITE)).append((Component)Component.translatable((String)("tooltip.relics." + id + ".ability." + name + ".description")).withStyle(ChatFormatting.GRAY)));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.relics.relic.tooltip.shift").withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.relics.relic.tooltip.table").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.literal((String)" "));
    }

    @Inject(method={"verifyComponentsAfterLoad"}, at={@At(value="HEAD")})
    public void onVerifyComponentsAfterLoad(ItemStack stack, CallbackInfo ci) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        for (AbilityData abilityData : relic.getAbilitiesData().getAbilities().values()) {
            String abilityId = abilityData.getId();
            if (relic.getAbilityComponent(stack, abilityId) == null) {
                relic.randomizeAbility(stack, abilityId);
                continue;
            }
            for (StatData statData : relic.getAbilityData(abilityId).getStats().values()) {
                String statId = statData.getId();
                if (relic.getStatComponent(stack, abilityId, statId) != null) continue;
                relic.randomizeStat(stack, abilityId, statId);
            }
        }
    }
}

