/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.level;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.LootCodecRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class RelicLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<RelicLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> RelicLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, RelicLootModifier::new)));

    public RelicLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String lootId = context.getQueriedLootTableId().toString();
        block2: for (IRelicItem relic : RelicStorage.RELICS.keySet()) {
            for (Map.Entry<String, Float> entry : relic.getLootData().getCollection().getEntries().entrySet()) {
                boolean isValid;
                String pattern = entry.getKey();
                float chance = entry.getValue().floatValue();
                try {
                    isValid = lootId.matches(pattern);
                }
                catch (PatternSyntaxException exception) {
                    isValid = lootId.equals(pattern);
                }
                if (!isValid) continue;
                if (!(context.getRandom().nextFloat() <= chance)) continue block2;
                generatedLoot.add((Object)relic.getItem().getDefaultInstance());
                continue block2;
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)LootCodecRegistry.RELIC_LOOT.get();
    }
}

