/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.entities.StalactiteEntity;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class ReflectionNecklaceItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("explode").stat(StatData.builder("capacity").initialValue(20.0, 60.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.35).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("damage").initialValue(0.25, 0.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 2)).build()).stat(StatData.builder("stun").initialValue(0.05, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 2)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-16729345).borderBottom(-16740183).textured(true).build()).background(Backgrounds.NETHER).build()).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block10: {
            block9: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block9;
                player = (Player)livingEntity;
                if (player.tickCount % 20 == 0) break block10;
            }
            return;
        }
        int time = (Integer)stack.getOrDefault(DataComponentRegistry.TIME, (Object)0);
        double charge = ((Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)).intValue();
        if (time > 0 && charge < this.getStatValue(stack, "explode", "capacity")) {
            stack.set(DataComponentRegistry.TIME, (Object)(--time));
        } else if (charge > 0.0) {
            Level level = player.level();
            RandomSource random = player.getRandom();
            float size = (float)(Math.log(charge) * (double)0.6f);
            float speed = (float)((double)0.35f + charge * (double)0.001f);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (random.nextDouble() - random.nextDouble());
                        double d4 = (double)i + (random.nextDouble() - random.nextDouble());
                        double d5 = (double)k + (random.nextDouble() - random.nextDouble());
                        double d6 = (double)Mth.sqrt((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / (double)speed + random.nextGaussian();
                        Vec3 motion = new Vec3(d3 / d6, d4 / d6, d5 / d6);
                        float mul = player.getBbHeight() / 1.5f;
                        Vec3 pos = player.position().add(0.0, (double)mul, 0.0).add(motion.normalize().multiply((double)mul, (double)mul, (double)mul));
                        if (level.getBlockState(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z)).blocksMotion()) continue;
                        StalactiteEntity stalactite = new StalactiteEntity(level, (float)(charge * this.getStatValue(stack, "explode", "damage")), (float)(charge * this.getStatValue(stack, "explode", "stun")));
                        stalactite.setOwner((Entity)player);
                        stalactite.setPos(pos);
                        stalactite.setDeltaMovement(motion);
                        level.addFreshEntity((Entity)stalactite);
                    }
                }
            }
            this.spreadExperience((LivingEntity)player, stack, (int)Math.floor(charge / 10.0));
            stack.set(DataComponentRegistry.CHARGE, (Object)0);
            stack.set(DataComponentRegistry.TIME, (Object)0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.scale(2.0f, 2.0f, 2.0f);
        matrixStack.popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 0.0f, -4.15f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(0, 0).addBox(-1.5f, 5.125f, -5.15f, 3.0f, 5.0f, 1.0f, new CubeDeformation(-0.075f)).texOffs(0, 15).addBox(-1.0f, 6.375f, -5.775f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bone.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(6, 15).addBox(-0.675f, -1.325f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.475f, (float)-4.65f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @EventBusSubscriber(modid="relics")
    public static class ReflectionNecklaceServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingIncomingDamageEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.REFLECTION_NECKLACE.get());
            Item item = stack.getItem();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            double charge = ((Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)).intValue();
            double capacity = relic.getStatValue(stack, "explode", "capacity");
            if (charge < capacity) {
                stack.set(DataComponentRegistry.CHARGE, (Object)((int)Math.min(capacity, charge + (double)event.getAmount())));
                stack.set(DataComponentRegistry.TIME, (Object)5);
            }
        }
    }
}

