/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class WoolMittenItem
extends RelicItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("mold").stat(StatData.builder("size").initialValue(12.0, 32.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("damage").initialValue(0.05, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).stat(StatData.builder("stun").initialValue(0.025, 0.05).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 3)).build()).stat(StatData.builder("freeze").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().background(Backgrounds.ICY).build()).loot(LootData.builder().entry(LootCollections.COLD).build()).build();
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
            int layers;
            Item item;
            Player player = event.getEntity();
            ItemStack relicStack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.WOOL_MITTEN.get());
            if (!(player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty() && (item = relicStack.getItem()) instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            Level level = player.level();
            BlockPos pos = event.getPos();
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            int n = block == Blocks.SNOW ? (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) : (layers = block == Blocks.SNOW_BLOCK ? 9 : 0);
            if (layers == 0) {
                return;
            }
            Inventory inventory = player.getInventory();
            int size = (int)Math.round(relic.getStatValue(relicStack, "mold", "size"));
            Optional<Integer> slot = EntityUtils.getSlotsWithItem(player, (Item)ItemRegistry.SOLID_SNOWBALL.get()).stream().filter(id -> NBTUtils.getInt(inventory.getItem(id.intValue()), "snow", 0) < size).max(Comparator.comparingInt(s -> NBTUtils.getInt((ItemStack)inventory.items.get(s.intValue()), "snow", 0)));
            if (slot.isEmpty()) {
                if (inventory.add(new ItemStack((ItemLike)ItemRegistry.SOLID_SNOWBALL.get()))) {
                    slot = EntityUtils.getSlotsWithItem(player, (Item)ItemRegistry.SOLID_SNOWBALL.get()).stream().findFirst();
                    if (slot.isEmpty()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            ItemStack stack = inventory.getItem(slot.get().intValue());
            level.destroyBlock(pos, false);
            int snow = NBTUtils.getInt(stack, "snow", 0);
            NBTUtils.setInt(stack, "snow", Math.min(snow + layers, size));
        }
    }
}

