/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

@EventBusSubscriber(modid="relics")
public class MagmaWalkerItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("heat_resistance").maxLevel(0).build()).ability(AbilityData.builder("pace").stat(StatData.builder("time").initialValue(20.0, 50.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().background(Backgrounds.NETHER).build()).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Player player;
        int heat;
        block7: {
            block6: {
                heat = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (player.tickCount % 20 == 0) break block7;
            }
            return;
        }
        if (heat > 0) {
            if ((double)heat > this.getStatValue(stack, "pace", "time")) {
                player.hurt(level.damageSources().hotFloor(), (float)(1.0 + ((double)heat - this.getStatValue(stack, "pace", "time")) / 10.0));
            }
            if (!level.getFluidState(player.blockPosition().below()).is(FluidTags.LAVA) && !level.getFluidState(player.blockPosition()).is(FluidTags.LAVA)) {
                stack.set(DataComponentRegistry.CHARGE, (Object)(--heat));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedCurioModel(stack.getItem());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        sidedModel.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        matrixStack.translate(0.0f, 0.0f, -0.025f);
        sidedModel.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition rightLeg = mesh.getRoot().addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 9).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).texOffs(18, 9).addBox(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.5f));
        rightLeg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, -1).addBox(1.5f, 5.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        rightLeg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, -1).mirror().addBox(-1.325f, 5.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftLeg = mesh.getRoot().addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 9).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).texOffs(18, 9).addBox(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.5f));
        leftLeg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, -1).addBox(1.5f, 5.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        leftLeg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, -1).mirror().addBox(-1.325f, 5.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_leg", "left_leg"});
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingIncomingDamageEvent event) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.MAGMA_WALKER.get());
        Item item = stack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            if (event.getSource() == event.getEntity().level().damageSources().hotFloor() && (double)((Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)).intValue() <= relic.getStatValue(stack, "pace", "time")) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onFluidCollide(FluidCollisionEvent event) {
        IRelicItem relic;
        Player player;
        ItemStack stack;
        block6: {
            block5: {
                stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.MAGMA_WALKER.get());
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                livingEntity = stack.getItem();
                if (!(livingEntity instanceof IRelicItem)) break block5;
                relic = (IRelicItem)livingEntity;
                if (event.getFluid().is(FluidTags.LAVA) && !player.isShiftKeyDown()) break block6;
            }
            return;
        }
        if (player.tickCount % 20 == 0) {
            int heat = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
            stack.set(DataComponentRegistry.CHARGE, (Object)(++heat));
            if (heat % 5 == 0) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }
        event.setCanceled(true);
    }
}

