/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.belt;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.SlotContext;

public class DrownedBeltItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("slots").requiredPoints(2).stat(StatData.builder("talisman").initialValue(0.0, 2.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).ability(AbilityData.builder("anchor").stat(StatData.builder("slowness").initialValue(0.5, 0.25).upgradeModifier(UpgradeOperation.ADD, -0.05).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).stat(StatData.builder("sinking").initialValue(5.0, 3.0).upgradeModifier(UpgradeOperation.ADD, -0.1).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).build()).ability(AbilityData.builder("pressure").stat(StatData.builder("damage").initialValue(1.25, 2.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).build()).ability(AbilityData.builder("riptide").stat(StatData.builder("cooldown").initialValue(10.0, 5.0).upgradeModifier(UpgradeOperation.ADD, -0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().background(Backgrounds.AQUATIC).build()).loot(LootData.builder().entry(LootCollections.AQUATIC).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.isEyeInFluid(FluidTags.WATER) && !player.onGround()) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.GRAVITY, (float)this.getStatValue(stack, "anchor", "sinking"), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @Override
    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().entry((Pair<String, Integer>)Pair.of((Object)"talisman", (Object)((int)Math.round(this.getStatValue(stack, "slots", "talisman"))))).build();
    }

    @Override
    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, (float)(-this.getStatValue(stack, "anchor", "slowness")))).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, 9.0f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bone.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 7).addBox(-2.05f, -1.5f, -0.5f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.5f, (float)-0.1295f, (float)-0.0378f, (float)0.0894f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onEntityHurt(LivingIncomingDamageEvent event) {
            Player player;
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof Player && (player = (Player)entity).isUnderWater() && event.getEntity().isUnderWater())) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DROWNED_BELT.get());
            Item item = stack.getItem();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            event.setAmount((float)((double)event.getAmount() * relic.getStatValue(stack, "pressure", "damage")));
        }

        @SubscribeEvent
        public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
            block3: {
                block2: {
                    ItemStack stack = event.getItem();
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block2;
                    Player player = (Player)livingEntity;
                    if (stack.getItem() == Items.TRIDENT && player.getCooldowns().isOnCooldown(stack.getItem())) break block3;
                }
                return;
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onItemUseFinish(LivingEntityUseItemEvent.Stop event) {
            Player player;
            ItemStack trident;
            block6: {
                block5: {
                    trident = event.getItem();
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block5;
                    player = (Player)livingEntity;
                    if (trident.getItem() == Items.TRIDENT) break block6;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DROWNED_BELT.get());
            Item item = stack.getItem();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            int duration = trident.getItem().getUseDuration(trident, (LivingEntity)player) - event.getDuration();
            int enchantment = trident.getEnchantmentLevel((Holder)player.level().holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.RIPTIDE));
            if (duration < 10 || enchantment <= 0) {
                return;
            }
            relic.spreadExperience((LivingEntity)player, stack, enchantment);
            player.getCooldowns().addCooldown(trident.getItem(), (int)Math.round(relic.getStatValue(stack, "riptide", "cooldown") * (double)enchantment * 20.0));
        }
    }
}

