/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.cast.misc;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.IRelicContainer;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityReference;
import it.hurts.sskirillss.relics.system.casts.slots.CurioSlotReference;
import it.hurts.sskirillss.relics.system.casts.slots.InventorySlotReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public enum RelicContainer implements IRelicContainer
{
    CURIOS{

        @Override
        public Function<LivingEntity, List<ItemStack>> gatherRelics() {
            return entity -> {
                ArrayList relics = new ArrayList();
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(itemHandler -> {
                    for (Map.Entry entry : itemHandler.getCurios().entrySet()) {
                        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                        for (int slot = 0; slot < stacksHandler.getSlots(); ++slot) {
                            ItemStack stack = stacksHandler.getStacks().getStackInSlot(slot);
                            if (!(stack.getItem() instanceof IRelicItem)) continue;
                            relics.add(stack);
                        }
                    }
                });
                return relics;
            };
        }

        @Override
        public Function<LivingEntity, List<AbilityReference>> gatherAbilities() {
            return entity -> {
                ArrayList references = new ArrayList();
                if (!(entity instanceof Player)) {
                    return references;
                }
                Player player = (Player)entity;
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(itemHandler -> {
                    for (Map.Entry entry : itemHandler.getCurios().entrySet()) {
                        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                        for (int slot = 0; slot < stacksHandler.getSlots(); ++slot) {
                            ItemStack stack = stacksHandler.getStacks().getStackInSlot(slot);
                            Item patt0$temp = stack.getItem();
                            if (!(patt0$temp instanceof IRelicItem)) continue;
                            IRelicItem relic = (IRelicItem)patt0$temp;
                            for (AbilityData abilityData : relic.getRelicData().getAbilities().getAbilities().values()) {
                                CastData castData;
                                String id = abilityData.getId();
                                if (!relic.canUseAbility(stack, id) || !relic.canSeeAbility(player, stack, id) || (castData = abilityData.getCastData()).getType() == CastType.NONE || !castData.getContainer().contains(CURIOS)) continue;
                                references.add(new AbilityReference(abilityData.getId(), new CurioSlotReference(slot, (String)entry.getKey())));
                            }
                        }
                    }
                });
                return references;
            };
        }
    }
    ,
    INVENTORY{

        @Override
        public Function<LivingEntity, List<ItemStack>> gatherRelics() {
            return entity -> {
                ArrayList<ItemStack> relics = new ArrayList<ItemStack>();
                if (!(entity instanceof Player)) {
                    return relics;
                }
                Player player = (Player)entity;
                for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
                    ItemStack stack = player.getInventory().getItem(slot);
                    if (!(stack.getItem() instanceof IRelicItem)) continue;
                    relics.add(stack);
                }
                return relics;
            };
        }

        @Override
        public Function<LivingEntity, List<AbilityReference>> gatherAbilities() {
            return entity -> {
                ArrayList<AbilityReference> references = new ArrayList<AbilityReference>();
                if (!(entity instanceof Player)) {
                    return references;
                }
                Player player = (Player)entity;
                for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
                    ItemStack stack = player.getInventory().getItem(slot);
                    Item patt0$temp = stack.getItem();
                    if (!(patt0$temp instanceof IRelicItem)) continue;
                    IRelicItem relic = (IRelicItem)patt0$temp;
                    for (AbilityData abilityData : relic.getRelicData().getAbilities().getAbilities().values()) {
                        CastData castData;
                        String id = abilityData.getId();
                        if (!relic.canUseAbility(stack, id) || !relic.canSeeAbility(player, stack, id) || (castData = abilityData.getCastData()).getType() == CastType.NONE || !castData.getContainer().contains(INVENTORY)) continue;
                        references.add(new AbilityReference(abilityData.getId(), new InventorySlotReference(slot)));
                    }
                }
                return references;
            };
        }
    };

}

