/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base;

import it.hurts.sskirillss.octolib.config.data.ConfigContext;
import it.hurts.sskirillss.octolib.config.data.OctoConfig;
import it.hurts.sskirillss.relics.api.events.leveling.ExperienceAddEvent;
import it.hurts.sskirillss.relics.capability.utils.CapabilityUtils;
import it.hurts.sskirillss.relics.components.AbilitiesComponent;
import it.hurts.sskirillss.relics.components.AbilityComponent;
import it.hurts.sskirillss.relics.components.DataComponent;
import it.hurts.sskirillss.relics.components.LevelingComponent;
import it.hurts.sskirillss.relics.components.StatComponent;
import it.hurts.sskirillss.relics.config.ConfigHelper;
import it.hurts.sskirillss.relics.entities.RelicExperienceOrbEntity;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.RelicContainer;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.capability.CapabilitySyncPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.tuple.Pair;

public interface IRelicItem {
    @Nullable
    default public Item getItem() {
        Item item;
        IRelicItem iRelicItem = this;
        return iRelicItem instanceof Item ? (item = (Item)iRelicItem) : null;
    }

    public RelicData constructDefaultRelicData();

    @Nullable
    default public OctoConfig getConfig() {
        return ConfigHelper.getRelicConfig(this);
    }

    default public void appendConfig(ConfigContext context) {
    }

    default public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
    }

    default public void tickActiveAbilitySelection(ItemStack stack, Player player, String ability) {
    }

    @Nullable
    default public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().build();
    }

    @Nullable
    default public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().build();
    }

    default public RelicData getRelicData() {
        if (!RelicStorage.RELICS.containsKey(this)) {
            RelicStorage.RELICS.put(this, this.constructDefaultRelicData());
        }
        return RelicStorage.RELICS.get(this);
    }

    default public void setRelicData(RelicData data) {
        RelicStorage.RELICS.put(this, data);
    }

    default public AbilitiesData getAbilitiesData() {
        return this.getRelicData().getAbilities();
    }

    default public AbilityData getAbilityData(String ability) {
        return this.getAbilitiesData().getAbilities().get(ability);
    }

    default public StatData getStatData(String ability, String stat) {
        return this.getAbilityData(ability).getStats().get(stat);
    }

    default public LevelingData getLevelingData() {
        return this.getRelicData().getLeveling();
    }

    default public LootData getLootData() {
        return this.getRelicData().getLoot();
    }

    default public StyleData getStyleData() {
        return this.getRelicData().getStyle();
    }

    default public boolean isItemResearched(Player player) {
        Item item = this.getItem();
        return item != null && CapabilityUtils.getRelicsCapability(player).getResearchData().getBoolean(BuiltInRegistries.ITEM.getKey((Object)item).getPath() + "_researched");
    }

    default public void setItemResearched(Player player, boolean researched) {
        Item item = this.getItem();
        if (item == null) {
            return;
        }
        CapabilityUtils.getRelicsCapability(player).getResearchData().putBoolean(BuiltInRegistries.ITEM.getKey((Object)item).getPath() + "_researched", researched);
        if (!player.level().isClientSide()) {
            NetworkHandler.sendToClient(new CapabilitySyncPacket((CompoundTag)CapabilityUtils.getRelicsCapability(player).serializeNBT((HolderLookup.Provider)player.registryAccess())), (ServerPlayer)player);
        }
    }

    default public int getMaxQuality() {
        return 10;
    }

    default public int getStatQuality(ItemStack stack, String ability, String stat) {
        double max;
        StatData statData = this.getStatData(ability, stat);
        if (statData == null) {
            return 0;
        }
        Function<Double, ? extends Number> format = statData.getFormatValue();
        double initial = format.apply(this.getStatInitialValue(stack, ability, stat)).doubleValue();
        double min = format.apply((Double)statData.getInitialValue().getKey()).doubleValue();
        if (min == (max = format.apply((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return this.getMaxQuality();
        }
        return Mth.clamp((int)((int)Math.round((initial - min) / ((max - min) / (double)this.getMaxQuality()))), (int)0, (int)this.getMaxQuality());
    }

    default public double getStatByQuality(String ability, String stat, int quality) {
        double max;
        StatData statData = this.getStatData(ability, stat);
        if (statData == null) {
            return 0.0;
        }
        double min = (Double)statData.getInitialValue().getKey();
        if (min == (max = ((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return this.getMaxQuality();
        }
        return MathUtils.round(min + (max - min) / (double)this.getMaxQuality() * (double)quality, 5);
    }

    default public int getAbilityQuality(ItemStack stack, String ability) {
        Map<String, StatData> stats = this.getAbilityData(ability).getStats();
        if (stats.isEmpty()) {
            return 0;
        }
        int sum = 0;
        for (String stat : stats.keySet()) {
            sum += this.getStatQuality(stack, ability, stat);
        }
        return Mth.clamp((int)(sum / stats.size()), (int)0, (int)this.getMaxQuality());
    }

    default public int getRelicQuality(ItemStack stack) {
        Map<String, AbilityData> abilities = this.getRelicData().getAbilities().getAbilities();
        if (abilities.isEmpty()) {
            return 0;
        }
        int size = abilities.size();
        int sum = 0;
        for (Map.Entry<String, AbilityData> entry : abilities.entrySet()) {
            if (entry.getValue().getMaxLevel() == 0) {
                --size;
                continue;
            }
            sum += this.getAbilityQuality(stack, entry.getKey());
        }
        return Mth.clamp((int)(sum / size), (int)0, (int)this.getMaxQuality());
    }

    default public int getPoints(ItemStack stack) {
        return this.getLevelingComponent(stack).points();
    }

    default public void setPoints(ItemStack stack, int amount) {
        this.setLevelingComponent(stack, this.getLevelingComponent(stack).toBuilder().points(Math.max(0, amount)).build());
    }

    default public void addPoints(ItemStack stack, int amount) {
        this.setPoints(stack, this.getPoints(stack) + amount);
    }

    default public int getLevel(ItemStack stack) {
        return this.getLevelingComponent(stack).level();
    }

    default public void setLevel(ItemStack stack, int level) {
        this.setLevelingComponent(stack, this.getLevelingComponent(stack).toBuilder().level(Math.max(0, level)).build());
    }

    default public void addLevel(ItemStack stack, int amount) {
        if (amount > 0) {
            this.addPoints(stack, Mth.clamp((int)amount, (int)0, (int)(this.getLevelingData().getMaxLevel() - this.getLevel(stack))));
        }
        this.setLevel(stack, this.getLevel(stack) + amount);
    }

    default public int getExperience(ItemStack stack) {
        return this.getLevelingComponent(stack).experience();
    }

    default public void setExperience(ItemStack stack, int experience) {
        int level = this.getLevel(stack);
        if (level >= this.getLevelingData().getMaxLevel()) {
            return;
        }
        int requiredExp = this.getExperienceBetweenLevels(stack, level, level + 1);
        LevelingComponent levelingComponent = this.getLevelingComponent(stack);
        if (experience >= requiredExp) {
            int sumExp = this.getTotalExperienceForLevel(stack, level) + experience;
            int resultLevel = this.getLevelFromExperience(stack, sumExp);
            levelingComponent = levelingComponent.toBuilder().experience(Math.max(0, sumExp - this.getTotalExperienceForLevel(stack, resultLevel))).build();
            this.addPoints(stack, resultLevel - level);
            this.setLevel(stack, resultLevel);
        } else {
            levelingComponent = levelingComponent.toBuilder().experience(Mth.clamp((int)experience, (int)0, (int)requiredExp)).build();
        }
        this.setLevelingComponent(stack, levelingComponent);
    }

    default public boolean addExperience(ItemStack stack, int amount) {
        return this.addExperience(null, stack, amount);
    }

    default public boolean addExperience(@Nullable LivingEntity entity, ItemStack stack, int amount) {
        ExperienceAddEvent event = new ExperienceAddEvent((LivingEntity)(entity instanceof LivingEntity ? entity : null), stack, amount);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.setExperience(stack, this.getExperience(stack) + event.getAmount());
            return true;
        }
        return false;
    }

    default public void spreadExperience(@Nullable LivingEntity entity, ItemStack stack, int experience) {
        this.spreadExperience(entity, stack, experience, 0.25);
    }

    default public void spreadExperience(@Nullable LivingEntity entity, ItemStack stack, int experience, double percentage) {
        int toSpread;
        boolean isMaxLevel = this.isMaxLevel(stack);
        int n = toSpread = isMaxLevel ? experience : (int)Math.ceil((double)experience * percentage);
        if (!isMaxLevel) {
            this.addExperience(entity, stack, experience);
        }
        if (toSpread <= 0 || entity == null) {
            return;
        }
        ArrayList<ItemStack> relics = new ArrayList<ItemStack>();
        for (RelicContainer source : RelicContainer.values()) {
            relics.addAll(source.gatherRelics().apply(entity).stream().filter(entry -> !this.isMaxLevel((ItemStack)entry) && !stack.equals(entry)).toList());
        }
        if (relics.isEmpty()) {
            return;
        }
        ItemStack relicStack = (ItemStack)relics.get(entity.level().getRandom().nextInt(relics.size()));
        Item item = relicStack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            relic.addExperience(entity, relicStack, toSpread);
        }
    }

    default public void dropExperience(Level level, Vec3 pos, int amount) {
        if (amount <= 0) {
            return;
        }
        RandomSource random = level.getRandom();
        int orbs = Math.max(amount / RelicExperienceOrbEntity.getMaxExperience(), random.nextInt(amount) + 1);
        for (int i = 0; i < orbs; ++i) {
            RelicExperienceOrbEntity orb = new RelicExperienceOrbEntity((EntityType<? extends RelicExperienceOrbEntity>)((EntityType)EntityRegistry.RELIC_EXPERIENCE_ORB.get()), level);
            orb.setPos(pos);
            orb.setExperience(amount / orbs);
            orb.setDeltaMovement((-1.0f + 2.0f * random.nextFloat()) * 0.15f, 0.1f + random.nextFloat() * 0.2f, (-1.0f + 2.0f * random.nextFloat()) * 0.15f);
            level.addFreshEntity((Entity)orb);
        }
    }

    default public int getExperienceLeftForLevel(ItemStack stack, int level) {
        int currentLevel = this.getLevel(stack);
        return this.getExperienceBetweenLevels(stack, currentLevel, level) - this.getExperience(stack);
    }

    default public int getExperienceBetweenLevels(ItemStack stack, int from, int to) {
        return this.getTotalExperienceForLevel(stack, to) - this.getTotalExperienceForLevel(stack, from);
    }

    default public int getTotalExperienceForLevel(ItemStack stack, int level) {
        if (level <= 0) {
            return 0;
        }
        LevelingData levelingData = this.getLevelingData();
        if (levelingData == null) {
            return 0;
        }
        int result = levelingData.getInitialCost();
        for (int i = 1; i < level; ++i) {
            result += levelingData.getInitialCost() + levelingData.getStep() * i;
        }
        return result;
    }

    default public int getLevelFromExperience(ItemStack stack, int experience) {
        int amount;
        int result = 0;
        while ((amount = this.getTotalExperienceForLevel(stack, ++result)) <= experience) {
        }
        return result - 1;
    }

    default public boolean isMaxLevel(ItemStack stack) {
        return this.getLevel(stack) >= this.getLevelingData().getMaxLevel();
    }

    default public int getExchanges(ItemStack stack) {
        return NBTUtils.getInt(stack, "exchanges", 0);
    }

    default public void setExchanges(ItemStack stack, int amount) {
        NBTUtils.setInt(stack, "exchanges", Math.max(0, amount));
    }

    default public void addExchanges(ItemStack stack, int amount) {
        this.setExchanges(stack, this.getExchanges(stack) + amount);
    }

    default public int getExchangeCost(ItemStack stack) {
        return (int)(5.0f + 5.0f * ((float)this.getExchanges(stack) * 0.01f));
    }

    default public boolean isExchangeAvailable(Player player, ItemStack stack) {
        return this.getExchangeCost(stack) <= EntityUtils.getPlayerTotalExperience(player);
    }

    default public CastData getAbilityCastData(String ability) {
        return this.getAbilityData(ability).getCastData();
    }

    default public boolean testAbilityCastPredicates(Player player, ItemStack stack, String ability) {
        CastData data = this.getAbilityCastData(ability);
        for (Map.Entry<String, BiFunction<Player, ItemStack, Boolean>> entry : data.getCastPredicates().entrySet()) {
            if (entry.getValue().apply(player, stack).booleanValue()) continue;
            return false;
        }
        return true;
    }

    default public DataComponent getDataComponent(ItemStack stack) {
        return (DataComponent)stack.getOrDefault(DataComponentRegistry.DATA, (Object)DataComponent.EMPTY);
    }

    default public void setDataComponent(ItemStack stack, DataComponent component) {
        stack.set(DataComponentRegistry.DATA, (Object)component);
    }

    default public LevelingComponent getLevelingComponent(ItemStack stack) {
        return this.getDataComponent(stack).leveling();
    }

    default public void setLevelingComponent(ItemStack stack, LevelingComponent component) {
        this.setDataComponent(stack, this.getDataComponent(stack).toBuilder().leveling(component).build());
    }

    default public AbilitiesComponent getAbilitiesComponent(ItemStack stack) {
        return this.getDataComponent(stack).abilities();
    }

    default public void setAbilitiesComponent(ItemStack stack, AbilitiesComponent component) {
        this.setDataComponent(stack, this.getDataComponent(stack).toBuilder().abilities(component).build());
    }

    default public AbilityComponent getAbilityComponent(ItemStack stack, String ability) {
        AbilitiesComponent abilitiesComponent = this.getAbilitiesComponent(stack);
        AbilityComponent abilityComponent = abilitiesComponent.abilities().get(ability);
        AbilityData abilityData = this.getAbilityData(ability);
        if (abilityComponent != null) {
            return abilityComponent;
        }
        if (abilityData != null) {
            AbilityComponent.AbilityComponentBuilder builder = AbilityComponent.EMPTY.toBuilder();
            if (abilityData.getCastData().getType() == CastType.TOGGLEABLE) {
                builder.ticking(true);
            }
            abilityComponent = builder.build();
            this.setAbilitiesComponent(stack, abilitiesComponent.toBuilder().ability(ability, abilityComponent).build());
            return abilityComponent;
        }
        return null;
    }

    default public void setAbilityComponent(ItemStack stack, String ability, AbilityComponent component) {
        this.setAbilitiesComponent(stack, this.getAbilitiesComponent(stack).toBuilder().ability(ability, component).build());
    }

    default public StatComponent getStatComponent(ItemStack stack, String ability, String stat) {
        AbilityComponent abilityComponent = this.getAbilityComponent(stack, ability);
        StatComponent statComponent = abilityComponent.stats().get(stat);
        StatData statData = this.getStatData(ability, stat);
        if (statComponent != null) {
            return statComponent;
        }
        if (statData != null) {
            statComponent = StatComponent.EMPTY.toBuilder().initialValue(MathUtils.round(MathUtils.randomBetween(new Random(), (Double)statData.getInitialValue().getKey(), (Double)statData.getInitialValue().getValue()), 5)).build();
            this.setAbilityComponent(stack, ability, abilityComponent.toBuilder().stat(stat, statComponent).build());
            return statComponent;
        }
        return null;
    }

    default public void setStatComponent(ItemStack stack, String ability, String stat, StatComponent component) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().stat(stat, component).build());
    }

    default public double getStatInitialValue(ItemStack stack, String ability, String stat) {
        return this.getStatComponent(stack, ability, stat).initialValue();
    }

    default public void setStatInitialValue(ItemStack stack, String ability, String stat, double value) {
        this.setStatComponent(stack, ability, stat, this.getStatComponent(stack, ability, stat).toBuilder().initialValue(value).build());
    }

    default public void addStatInitialValue(ItemStack stack, String ability, String stat, double value) {
        this.setStatInitialValue(stack, ability, stat, this.getStatInitialValue(stack, ability, stat) + value);
    }

    default public int getAbilityPoints(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).points();
    }

    default public void setAbilityPoints(ItemStack stack, String ability, int points) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().points(points).build());
    }

    default public void addAbilityPoints(ItemStack stack, String ability, int points) {
        this.setAbilityPoints(stack, ability, this.getAbilityPoints(stack, ability) + points);
    }

    default public AbilityComponent randomizeAbility(ItemStack stack, String ability) {
        for (String stat : this.getAbilityData(ability).getStats().keySet()) {
            this.randomizeStat(stack, ability, stat);
        }
        return this.getAbilityComponent(stack, ability);
    }

    default public StatComponent randomizeStat(ItemStack stack, String ability, String stat) {
        StatData entry = this.getStatData(ability, stat);
        double result = MathUtils.round(MathUtils.randomBetween(new Random(), (Double)entry.getInitialValue().getKey(), (Double)entry.getInitialValue().getValue()), 5);
        this.setStatInitialValue(stack, ability, stat, result);
        return this.getStatComponent(stack, ability, stat);
    }

    default public void randomizeStats(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        for (String stat : entry.getStats().keySet()) {
            this.randomizeStat(stack, ability, stat);
        }
    }

    default public double getStatValue(ItemStack stack, String ability, String stat, int points) {
        StatData data = this.getStatData(ability, stat);
        double result = 0.0;
        if (data == null) {
            return result;
        }
        double current = this.getStatInitialValue(stack, ability, stat);
        double step = (Double)data.getUpgradeModifier().getValue();
        switch ((UpgradeOperation)((Object)data.getUpgradeModifier().getKey())) {
            case ADD: {
                result = current + (double)points * step;
                break;
            }
            case MULTIPLY_BASE: {
                result = current + current * step * (double)points;
                break;
            }
            case MULTIPLY_TOTAL: {
                result = current * Math.pow(step + 1.0, points);
            }
        }
        Pair<Double, Double> threshold = data.getThresholdValue();
        return MathUtils.round(Mth.clamp((double)result, (double)((Double)threshold.getKey()), (double)((Double)threshold.getValue())), 5);
    }

    default public double getStatValue(ItemStack stack, String ability, String stat) {
        return this.getStatValue(stack, ability, stat, this.getAbilityPoints(stack, ability));
    }

    default public boolean canUseAbility(ItemStack stack, String ability) {
        return this.getLevel(stack) >= this.getAbilityData(ability).getRequiredLevel();
    }

    default public boolean canSeeAbility(Player player, ItemStack stack, String ability) {
        for (BiFunction<Player, ItemStack, Boolean> predicate : this.getAbilityCastData(ability).getVisibilityPredicates()) {
            if (predicate.apply(player, stack).booleanValue()) continue;
            return false;
        }
        return true;
    }

    default public int getUpgradeRequiredExperience(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return (this.getAbilityPoints(stack, ability) + 1) * entry.getRequiredPoints() * count * 15;
    }

    default public boolean isAbilityMaxLevel(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        return entry.getStats().isEmpty() || this.getAbilityPoints(stack, ability) >= (entry.getMaxLevel() == -1 ? this.getLevelingData().getMaxLevel() / entry.getRequiredPoints() : entry.getMaxLevel());
    }

    default public boolean mayUpgrade(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        return !entry.getStats().isEmpty() && !this.isAbilityMaxLevel(stack, ability) && this.getPoints(stack) >= entry.getRequiredPoints() && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerUpgrade(Player player, ItemStack stack, String ability) {
        return this.mayUpgrade(stack, ability) && player.totalExperience >= this.getUpgradeRequiredExperience(stack, ability);
    }

    default public int getRerollRequiredExperience(String ability) {
        AbilityData entry = this.getAbilityData(ability);
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return 100 / count;
    }

    default public boolean mayReroll(ItemStack stack, String ability) {
        return !this.getAbilityData(ability).getStats().isEmpty() && this.getRerollRequiredExperience(ability) > 0 && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerReroll(Player player, ItemStack stack, String ability) {
        return this.mayReroll(stack, ability) && player.totalExperience >= this.getRerollRequiredExperience(ability);
    }

    default public int getResetRequiredExperience(ItemStack stack, String ability) {
        return this.getAbilityPoints(stack, ability) * 50;
    }

    default public boolean mayReset(ItemStack stack, String ability) {
        return this.getResetRequiredExperience(stack, ability) > 0 && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerReset(Player player, ItemStack stack, String ability) {
        return !this.getAbilityData(ability).getStats().isEmpty() && this.mayReset(stack, ability) && player.totalExperience >= this.getResetRequiredExperience(stack, ability);
    }

    default public int getAbilityCooldownCap(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).cooldownCap();
    }

    default public void setAbilityCooldownCap(ItemStack stack, String ability, int amount) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().cooldownCap(amount).build());
    }

    default public int getAbilityCooldown(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).cooldown();
    }

    default public void setAbilityCooldown(ItemStack stack, String ability, int amount) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().cooldownCap(amount).cooldown(amount).build());
    }

    default public void addAbilityCooldown(ItemStack stack, String ability, int amount) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().cooldown(this.getAbilityCooldown(stack, ability) + amount).build());
    }

    default public void setAbilityTicking(ItemStack stack, String ability, boolean ticking) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().ticking(ticking).build());
    }

    default public boolean isAbilityTicking(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).ticking();
    }

    default public boolean isAbilityOnCooldown(ItemStack stack, String ability) {
        return this.getAbilityCooldown(stack, ability) > 0;
    }

    default public boolean canPlayerUseActiveAbility(Player player, ItemStack stack, String ability) {
        return this.canUseAbility(stack, ability) && !this.isAbilityOnCooldown(stack, ability) && this.testAbilityCastPredicates(player, stack, ability);
    }
}

