/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.entities.DissectionEntity;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class SpaceDissectorItem
extends RelicItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("dissection").stat(StatData.builder("distance").initialValue(16.0, 32.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("time").initialValue(5.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().background(Backgrounds.NETHER).build()).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand handIn) {
        ItemStack stack = player.getItemInHand(handIn);
        String stringUUID = (String)stack.getOrDefault(DataComponentRegistry.PORTAL, (Object)"");
        if (!stringUUID.isEmpty()) {
            UUID uuid = UUID.fromString(stringUUID);
            if (!world.isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)world;
                DissectionEntity startPortal = (DissectionEntity)serverLevel.getEntity(uuid);
                if (startPortal != null) {
                    startPortal.setLifeTime(20);
                } else {
                    this.spreadExperience((LivingEntity)player, stack, 1);
                }
            }
        } else {
            this.spreadExperience((LivingEntity)player, stack, 1);
        }
        Vec3 view = player.getViewVector(0.0f);
        Vec3 eyeVec = player.getEyePosition(0.0f);
        float distance = Math.round(this.getStatValue(stack, "dissection", "distance"));
        BlockHitResult ray = world.clip(new ClipContext(eyeVec, eyeVec.add(view.x * (double)distance, view.y * (double)distance, view.z * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        DissectionEntity portal = new DissectionEntity(world);
        int time = (int)Math.round(this.getStatValue(stack, "dissection", "time")) * 20;
        portal.setPos(ray.getLocation());
        portal.setMaxLifeTime(time);
        portal.setLifeTime(time);
        portal.setMaster(true);
        world.addFreshEntity((Entity)portal);
        stack.set(DataComponentRegistry.PORTAL, (Object)portal.getStringUUID());
        player.startUsingItem(handIn);
        return super.use(world, player, handIn);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity pLivingEntity, int pTimeCharged) {
        if (!(pLivingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pLivingEntity;
        Vec3 view = player.getViewVector(0.0f);
        Vec3 eyeVec = player.getEyePosition(0.0f);
        float distance = Math.round(this.getStatValue(stack, "dissection", "distance"));
        BlockHitResult ray = world.clip(new ClipContext(eyeVec, eyeVec.add(view.x * (double)distance, view.y * (double)distance, view.z * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 targetVec = ray.getLocation();
        String stringUUID = (String)stack.getOrDefault(DataComponentRegistry.PORTAL, (Object)"");
        if (stringUUID.isEmpty()) {
            return;
        }
        UUID uuid = UUID.fromString(stringUUID);
        if (world.isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        DissectionEntity startPortal = (DissectionEntity)serverLevel.getEntity(uuid);
        if (startPortal == null) {
            return;
        }
        DissectionEntity endPortal = new DissectionEntity(world);
        endPortal.setPos(targetVec);
        endPortal.setMaster(false);
        world.addFreshEntity((Entity)endPortal);
        startPortal.setPair(endPortal);
        endPortal.setPair(startPortal);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        RandomSource random = level.getRandom();
        Vec3 view = entity.getViewVector(0.0f);
        Vec3 eyeVec = entity.getEyePosition(0.0f);
        float distance = Math.round(this.getStatValue(stack, "dissection", "distance"));
        BlockHitResult ray = level.clip(new ClipContext(eyeVec, eyeVec.add(view.x * (double)distance, view.y * (double)distance, view.z * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
        Vec3 targetVec = ray.getLocation();
        ParticleUtils.createBall(ParticleUtils.constructSimpleSpark(new Color(150 + random.nextInt(100), 100, 0), 0.2f + random.nextFloat() * 0.1f, 10 + random.nextInt(20), 0.9f), targetVec, level, 1, 0.25f);
        String stringUUID = (String)stack.getOrDefault(DataComponentRegistry.PORTAL, (Object)"");
        if (stringUUID.isEmpty()) {
            return;
        }
        UUID uuid = UUID.fromString(stringUUID);
        if (level.isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        DissectionEntity startPortal = (DissectionEntity)serverLevel.getEntity(uuid);
        if (startPortal == null) {
            return;
        }
        startPortal.lookAt(EntityAnchorArgument.Anchor.FEET, targetVec);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }
}

