/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class InfinityHamItem
extends RelicItem {
    private static final String TAG_POTION = "potion";

    public InfinityHamItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
    }

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("autophagy").stat(StatData.builder("feed").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder("infusion").requiredLevel(5).stat(StatData.builder("duration").initialValue(1.0, 3.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().background(Backgrounds.PLAINS).build()).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    @Override
    public List<ItemStack> processCreativeTab() {
        ItemStack stack = this.getDefaultInstance();
        stack.set(DataComponentRegistry.CHARGE, (Object)10);
        return Lists.newArrayList((Object[])new ItemStack[]{stack});
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        if (entityIn.tickCount % 20 != 0 || !(entityIn instanceof Player) || (player = (Player)entityIn).isUsingItem()) {
            return;
        }
        int pieces = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
        if (pieces >= 10) {
            return;
        }
        int charge = (Integer)stack.getOrDefault(DataComponentRegistry.TIME, (Object)0);
        if (charge >= 10) {
            stack.set(DataComponentRegistry.CHARGE, (Object)(++pieces));
            stack.set(DataComponentRegistry.TIME, (Object)0);
        } else {
            stack.set(DataComponentRegistry.TIME, (Object)(++charge));
        }
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if ((Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0) > 0 && (player.getFoodData().needsFood() || player.isCreative())) {
            player.startUsingItem(hand);
        }
        return super.use(world, player, hand);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.getFoodData().needsFood() && !player.isCreative()) {
            player.stopUsingItem();
            return;
        }
        if (player.tickCount % 10 != 0) {
            return;
        }
        int pieces = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
        CompoundTag nbt = NBTUtils.getOrCreateTag(stack);
        if (pieces > 0) {
            stack.set(DataComponentRegistry.CHARGE, (Object)(--pieces));
            int feed = (int)Math.round(this.getStatValue(stack, "autophagy", "feed"));
            player.getFoodData().eat(feed, (float)feed);
            this.spreadExperience((LivingEntity)player, stack, Math.max(1, Math.min(20 - player.getFoodData().getFoodLevel(), feed)));
            if (!this.canUseAbility(stack, "infusion") || !nbt.contains(TAG_POTION, 9)) {
                return;
            }
            int duration = (int)Math.round(this.getStatValue(stack, "infusion", "duration") * 20.0);
            ListTag list = nbt.getList(TAG_POTION, 10);
            for (int i = 0; i < list.size(); ++i) {
                MobEffectInstance effect = MobEffectInstance.load((CompoundTag)list.getCompound(i));
                if (effect == null || ((MobEffect)effect.getEffect().value()).isInstantenous()) continue;
                MobEffectInstance currentEffect = player.getEffect(effect.getEffect());
                player.addEffect(new MobEffectInstance(effect.getEffect(), currentEffect == null ? duration : currentEffect.getDuration() + duration, effect.getAmplifier()));
            }
            if (pieces <= 0 && nbt.contains(TAG_POTION)) {
                nbt.remove(TAG_POTION);
            }
        } else {
            player.stopUsingItem();
        }
    }

    public boolean isFoil(ItemStack stack) {
        return NBTUtils.getOrCreateTag(stack).contains(TAG_POTION);
    }

    public int getUseDuration(@NotNull ItemStack stack, LivingEntity entity) {
        return 50;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }
}

