/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items;

import it.hurts.sskirillss.relics.entities.SolidSnowballEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.ItemBase;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class SolidSnowballItem
extends ItemBase {
    public static final String TAG_SNOW = "snow";

    public SolidSnowballItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    @Override
    public List<ItemStack> processCreativeTab() {
        return new ArrayList<ItemStack>();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (EntityUtils.findEquippedCurio(entity, (Item)ItemRegistry.WOOL_MITTEN.get()).isEmpty()) {
            entity.setTicksFrozen(entity.getTicksFrozen() + 3);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        SolidSnowballEntity entity = new SolidSnowballEntity(level);
        entity.setOwner((Entity)player);
        entity.setPos(player.getX(), player.getEyeY(), player.getZ());
        entity.setSize(NBTUtils.getInt(stack, TAG_SNOW, 0));
        entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)entity);
        level.playSound(null, player.blockPosition(), SoundEvents.SNOWBALL_THROW, SoundSource.MASTER, 0.5f, 0.5f);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

