/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SolidSnowballEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(SolidSnowballEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public void setSize(int amount) {
        this.getEntityData().set(SIZE, (Object)amount);
    }

    public int getSize() {
        return (Integer)this.getEntityData().get(SIZE);
    }

    public SolidSnowballEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SolidSnowballEntity(Level level) {
        super((EntityType)EntityRegistry.SOLID_SNOWBALL.get(), level);
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.tickCount > 300) {
            this.discard();
        }
        if ((level = this.level()).isClientSide()) {
            return;
        }
        float scale = (float)this.getSize() * 0.0035f;
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, this.xo, this.yo + (double)(this.getBbHeight() / 2.0f), this.zo, 3, (double)scale, (double)scale, (double)scale, (double)0.025f);
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockPos pos = result.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        if (!state.blocksMotion()) {
            return;
        }
        this.discard();
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity entity;
        block11: {
            block10: {
                Entity entity2;
                if (this.level().isClientSide() || !((entity2 = result.getEntity()) instanceof LivingEntity)) break block10;
                entity = (LivingEntity)entity2;
                if (this.getOwner() == null || !entity.getStringUUID().equals(this.getOwner().getStringUUID())) break block11;
            }
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio(this.getOwner(), (Item)ItemRegistry.WOOL_MITTEN.get());
        Item item = stack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            boolean mayContinue = false;
            float damage = (float)((double)this.getSize() * relic.getStatValue(stack, "mold", "damage"));
            Entity entity3 = this.getOwner();
            if (entity3 instanceof Player) {
                Player player = (Player)entity3;
                if (EntityUtils.hurt(entity, this.level().damageSources().thrown((Entity)this, (Entity)player), damage)) {
                    mayContinue = true;
                }
            } else if (entity.hurt(this.level().damageSources().magic(), damage)) {
                mayContinue = true;
            }
            if (mayContinue) {
                entity.addEffect(new MobEffectInstance(EffectRegistry.STUN, (int)Math.round((double)this.getSize() * relic.getStatValue(stack, "mold", "stun")) * 20, 0, true, false));
            }
        }
        this.discard();
    }

    public void onRemovedFromWorld() {
        ParticleUtils.createBall((ParticleOptions)ParticleTypes.SNOWFLAKE, this.position(), this.level(), 1 + this.getSize() / 10, 0.1f + (float)this.getSize() * 0.005f);
        if (this.level().isClientSide()) {
            return;
        }
        Entity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio(owner, (Item)ItemRegistry.WOOL_MITTEN.get());
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)((float)this.getSize() / 15.0f)))) {
            if (entity.getStringUUID().equals(owner.getStringUUID())) continue;
            entity.setTicksFrozen((int)(100L + Math.round((double)this.getSize() * relic.getStatValue(EntityUtils.findEquippedCurio(owner, (Item)ItemRegistry.WOOL_MITTEN.get()), "mold", "freeze"))));
        }
        if (owner instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)owner;
            relic.spreadExperience(entity, stack, (int)Math.floor((float)this.getSize() / 5.0f));
        }
        this.level().playSound(null, this.blockPosition(), SoundEvents.SNOW_BREAK, SoundSource.MASTER, 1.0f, 0.5f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SIZE, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setSize(compound.getInt("Size"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("Size", (float)this.getSize());
    }

    public boolean isPushedByFluid() {
        return false;
    }
}

