/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ShadowGlaiveEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.defineId(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> TARGET = SynchedEntityData.defineId(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> BOUNCED_ENTITIES = SynchedEntityData.defineId(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final String TAG_BOUNCES_AMOUNT = "bounces";
    private static final String TAG_TARGET_UUID = "target";
    private static final String TAG_BOUNCED_ENTITIES = "entities";
    private boolean isBounced = false;
    private LivingEntity target;
    private ItemStack stack = ItemStack.EMPTY;

    public ShadowGlaiveEntity(EntityType<? extends ShadowGlaiveEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public ShadowGlaiveEntity(Level world, LivingEntity throwerIn) {
        super((EntityType)EntityRegistry.SHADOW_GLAIVE.get(), throwerIn, world);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (target != null) {
            this.entityData.set(TARGET, (Object)target.getUUID().toString());
        }
    }

    private void locateNearestTarget() {
        Item item = this.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        if ((double)((Integer)this.entityData.get(BOUNCES)).intValue() >= relic.getStatValue(this.stack, "glaive", TAG_BOUNCES_AMOUNT)) {
            this.discard();
            return;
        }
        List<String> bouncedEntities = Arrays.asList(((String)this.entityData.get(BOUNCED_ENTITIES)).split(","));
        List entitiesAround = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(relic.getStatValue(this.stack, "glaive", "radius")));
        if ((entitiesAround = entitiesAround.stream().filter(entity -> !bouncedEntities.contains(entity.getUUID().toString())).filter(EntitySelector.NO_CREATIVE_OR_SPECTATOR).filter(entity -> {
            Entity patt0$temp = this.getOwner();
            if (!(patt0$temp instanceof Player)) {
                return false;
            }
            Player player = (Player)patt0$temp;
            return !entity.getStringUUID().equals(player.getStringUUID()) && !EntityUtils.isAlliedTo((Entity)player, (Entity)entity);
        }).filter(entity -> entity.hasLineOfSight((Entity)this)).sorted(Comparator.comparing(entity -> entity.position().distanceTo(this.position()))).collect(Collectors.toList())).isEmpty()) {
            if (this.isBounced) {
                this.discard();
            }
            return;
        }
        LivingEntity target = null;
        for (LivingEntity entity2 : entitiesAround) {
            if (entity2 == null || !entity2.isAlive()) continue;
            target = entity2;
            break;
        }
        if (target == null || !target.isAlive()) {
            this.discard();
            return;
        }
        this.setTarget(target);
    }

    public void tick() {
        super.tick();
        Item item = this.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        for (int i = 0; i < 3; ++i) {
            this.level().addParticle(ParticleUtils.constructSimpleSpark(new Color(255, this.random.nextInt(100), 255), 0.2f, 30, 0.99f), this.xo, this.yo, this.zo, (double)(MathUtils.randomFloat(this.random) * 0.01f), 0.0, (double)(MathUtils.randomFloat(this.random) * 0.01f));
        }
        if (this.level().isClientSide()) {
            return;
        }
        if (!this.isBounced && this.target == null && this.tickCount > 30) {
            this.discard();
        }
        if (this.tickCount > 300) {
            this.discard();
        }
        if (this.target == null && this.tickCount > 10 && this.tickCount % 2 == 0) {
            this.locateNearestTarget();
            return;
        }
        if (this.target != null && this.target.isAlive()) {
            EntityUtils.moveTowardsPosition((Entity)this, this.target.position().add(0.0, (double)this.target.getBbHeight() * 0.5, 0.0), 0.75);
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.3, 3.0, 0.3))) {
                Entity entity2 = this.getOwner();
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    if (entity.getStringUUID().equals(player.getStringUUID())) continue;
                }
                String bouncedEntitiesString = (String)this.entityData.get(BOUNCED_ENTITIES);
                List<String> bouncedEntities = Arrays.asList(bouncedEntitiesString.split(","));
                float damage = (float)relic.getStatValue(this.stack, "glaive", "damage");
                Entity entity3 = this.getOwner();
                if (entity3 instanceof Player) {
                    Player player = (Player)entity3;
                    if (EntityUtils.hurt(entity, this.level().damageSources().thrown((Entity)this, (Entity)player), damage)) {
                        relic.spreadExperience((LivingEntity)player, this.stack, 1);
                    }
                } else {
                    entity.hurt(this.level().damageSources().magic(), damage);
                }
                if (!bouncedEntities.contains(entity.getUUID().toString())) {
                    this.entityData.set(BOUNCED_ENTITIES, (Object)(bouncedEntitiesString + "," + String.valueOf(entity.getUUID())));
                    this.entityData.set(BOUNCES, (Object)((Integer)this.entityData.get(BOUNCES) + 1));
                    this.isBounced = true;
                }
                this.locateNearestTarget();
                break;
            }
        } else {
            this.locateNearestTarget();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BOUNCES, (Object)0);
        builder.define(TARGET, (Object)"");
        builder.define(BOUNCED_ENTITIES, (Object)"");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt(TAG_BOUNCES_AMOUNT, ((Integer)this.entityData.get(BOUNCES)).intValue());
        tag.putString(TAG_TARGET_UUID, (String)this.entityData.get(TARGET));
        tag.putString(TAG_BOUNCED_ENTITIES, (String)this.entityData.get(BOUNCED_ENTITIES));
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(BOUNCES, (Object)tag.getInt(TAG_BOUNCES_AMOUNT));
        this.entityData.set(TARGET, (Object)tag.getString(TAG_TARGET_UUID));
        this.entityData.set(BOUNCED_ENTITIES, (Object)tag.getString(TAG_BOUNCED_ENTITIES));
        super.readAdditionalSaveData(tag);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

