/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class LifeEssenceEntity
extends ThrowableProjectile {
    private float heal;

    public LifeEssenceEntity(EntityType<? extends LifeEssenceEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public LifeEssenceEntity(LivingEntity throwerIn, float heal) {
        super((EntityType)EntityRegistry.LIFE_ESSENCE.get(), throwerIn.getCommandSenderWorld());
        this.setOwner((Entity)throwerIn);
        this.heal = heal;
    }

    public void tick() {
        Player player;
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        RandomSource random = this.level().getRandom();
        double size = 0.02 + (double)this.heal * 0.001;
        ((ServerLevel)this.level()).sendParticles(ParticleUtils.constructSimpleSpark(new Color(200, 150 + random.nextInt(50), random.nextInt(50)), 0.1f + this.heal * 0.01f, 20 + Math.round(this.heal * 0.025f), 0.9f), this.xo, this.yo, this.zo, 1, size, size, size, (double)(0.01f + this.heal * 1.0E-4f));
        Entity entity = this.getOwner();
        if (!(entity instanceof Player) || (player = (Player)entity).isDeadOrDying()) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        for (LifeEssenceEntity essence : this.level().getEntitiesOfClass(LifeEssenceEntity.class, this.getBoundingBox().inflate((double)(this.heal * 0.05f)))) {
            if (essence.getStringUUID().equals(this.getStringUUID())) continue;
            Entity entity2 = essence.getOwner();
            if (entity2 instanceof Player) {
                Player p1 = (Player)entity2;
                entity2 = this.getOwner();
                if (entity2 instanceof Player) {
                    Player p2 = (Player)entity2;
                    if (!p1.getStringUUID().equals(p2.getStringUUID())) continue;
                }
            }
            this.setHeal(this.getHeal() + essence.getHeal());
            essence.remove(Entity.RemovalReason.KILLED);
        }
        double distance = this.position().distanceTo(player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0));
        if (distance > 1.0) {
            if (distance > 32.0) {
                this.remove(Entity.RemovalReason.KILLED);
                return;
            }
            EntityUtils.moveTowardsPosition((Entity)this, player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0), 0.25);
        } else {
            player.heal(this.heal);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void setHeal(float heal) {
        this.heal = heal;
    }

    public float getHeal() {
        return this.heal;
    }
}

