/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record LevelingComponent(int level, int experience, int points) {
    public static final LevelingComponent EMPTY = new LevelingComponent(0, 0, 0);
    public static final Codec<LevelingComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("level").forGetter(LevelingComponent::level), (App)Codec.INT.fieldOf("experience").forGetter(LevelingComponent::experience), (App)Codec.INT.fieldOf("points").forGetter(LevelingComponent::points)).apply((Applicative)instance, LevelingComponent::new));
    public static final StreamCodec<ByteBuf, LevelingComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LevelingComponent::level, (StreamCodec)ByteBufCodecs.INT, LevelingComponent::experience, (StreamCodec)ByteBufCodecs.INT, LevelingComponent::points, LevelingComponent::new);

    public static LevelingComponentBuilder builder() {
        return new LevelingComponentBuilder();
    }

    public LevelingComponentBuilder toBuilder() {
        return new LevelingComponentBuilder().level(this.level).experience(this.experience).points(this.points);
    }

    public static class LevelingComponentBuilder {
        private int level;
        private int experience;
        private int points;

        LevelingComponentBuilder() {
        }

        public LevelingComponentBuilder level(int level) {
            this.level = level;
            return this;
        }

        public LevelingComponentBuilder experience(int experience) {
            this.experience = experience;
            return this;
        }

        public LevelingComponentBuilder points(int points) {
            this.points = points;
            return this;
        }

        public LevelingComponent build() {
            return new LevelingComponent(this.level, this.experience, this.points);
        }

        public String toString() {
            return "LevelingComponent.LevelingComponentBuilder(level=" + this.level + ", experience=" + this.experience + ", points=" + this.points + ")";
        }
    }
}

