/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.components.StatComponent;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record AbilityComponent(Map<String, StatComponent> stats, int points, int cooldownCap, int cooldown, boolean ticking) {
    public static final AbilityComponent EMPTY = new AbilityComponent(Map.of(), 0, 0, 0, false);
    public static final Codec<AbilityComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, StatComponent.CODEC).fieldOf("stats").forGetter(AbilityComponent::stats), (App)Codec.INT.fieldOf("points").forGetter(AbilityComponent::points), (App)Codec.INT.fieldOf("cooldownCap").forGetter(AbilityComponent::cooldownCap), (App)Codec.INT.fieldOf("cooldown").forGetter(AbilityComponent::cooldown), (App)Codec.BOOL.fieldOf("ticking").forGetter(AbilityComponent::ticking)).apply((Applicative)instance, AbilityComponent::new));
    public static final StreamCodec<ByteBuf, AbilityComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Object2ObjectOpenHashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, StatComponent.STREAM_CODEC), AbilityComponent::stats, (StreamCodec)ByteBufCodecs.INT, AbilityComponent::points, (StreamCodec)ByteBufCodecs.INT, AbilityComponent::cooldownCap, (StreamCodec)ByteBufCodecs.INT, AbilityComponent::cooldown, (StreamCodec)ByteBufCodecs.BOOL, AbilityComponent::ticking, AbilityComponent::new);

    public static AbilityComponentBuilder builder() {
        return new AbilityComponentBuilder();
    }

    public AbilityComponentBuilder toBuilder() {
        AbilityComponentBuilder builder = new AbilityComponentBuilder().points(this.points).cooldownCap(this.cooldownCap).cooldown(this.cooldown).ticking(this.ticking);
        if (this.stats != null) {
            builder.stats(this.stats);
        }
        return builder;
    }

    public static class AbilityComponentBuilder {
        private ArrayList<String> stats$key;
        private ArrayList<StatComponent> stats$value;
        private int points;
        private int cooldownCap;
        private int cooldown;
        private boolean ticking;

        AbilityComponentBuilder() {
        }

        public AbilityComponentBuilder stat(String statKey, StatComponent statValue) {
            if (this.stats$key == null) {
                this.stats$key = new ArrayList();
                this.stats$value = new ArrayList();
            }
            this.stats$key.add(statKey);
            this.stats$value.add(statValue);
            return this;
        }

        public AbilityComponentBuilder stats(Map<? extends String, ? extends StatComponent> stats) {
            if (stats == null) {
                throw new NullPointerException("stats cannot be null");
            }
            if (this.stats$key == null) {
                this.stats$key = new ArrayList();
                this.stats$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends StatComponent> $lombokEntry : stats.entrySet()) {
                this.stats$key.add($lombokEntry.getKey());
                this.stats$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public AbilityComponentBuilder clearStats() {
            if (this.stats$key != null) {
                this.stats$key.clear();
                this.stats$value.clear();
            }
            return this;
        }

        public AbilityComponentBuilder points(int points) {
            this.points = points;
            return this;
        }

        public AbilityComponentBuilder cooldownCap(int cooldownCap) {
            this.cooldownCap = cooldownCap;
            return this;
        }

        public AbilityComponentBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public AbilityComponentBuilder ticking(boolean ticking) {
            this.ticking = ticking;
            return this;
        }

        public AbilityComponent build() {
            Map<String, StatComponent> stats;
            switch (this.stats$key == null ? 0 : this.stats$key.size()) {
                case 0: {
                    stats = Collections.emptyMap();
                    break;
                }
                case 1: {
                    stats = Collections.singletonMap(this.stats$key.get(0), this.stats$value.get(0));
                    break;
                }
                default: {
                    stats = new LinkedHashMap(this.stats$key.size() < 0x40000000 ? 1 + this.stats$key.size() + (this.stats$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.stats$key.size(); ++$i) {
                        stats.put(this.stats$key.get($i), this.stats$value.get($i));
                    }
                    stats = Collections.unmodifiableMap(stats);
                }
            }
            return new AbilityComponent(stats, this.points, this.cooldownCap, this.cooldown, this.ticking);
        }

        public String toString() {
            return "AbilityComponent.AbilityComponentBuilder(stats$key=" + String.valueOf(this.stats$key) + ", stats$value=" + String.valueOf(this.stats$value) + ", points=" + this.points + ", cooldownCap=" + this.cooldownCap + ", cooldown=" + this.cooldown + ", ticking=" + this.ticking + ")";
        }
    }
}

