/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.components.AbilityComponent;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record AbilitiesComponent(Map<String, AbilityComponent> abilities) {
    public static final AbilitiesComponent EMPTY = new AbilitiesComponent(Map.of());
    public static final Codec<AbilitiesComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, AbilityComponent.CODEC).fieldOf("abilities").forGetter(AbilitiesComponent::abilities)).apply((Applicative)instance, AbilitiesComponent::new));
    public static final StreamCodec<ByteBuf, AbilitiesComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Object2ObjectOpenHashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, AbilityComponent.STREAM_CODEC), AbilitiesComponent::abilities, AbilitiesComponent::new);

    public static AbilitiesComponentBuilder builder() {
        return new AbilitiesComponentBuilder();
    }

    public AbilitiesComponentBuilder toBuilder() {
        AbilitiesComponentBuilder builder = new AbilitiesComponentBuilder();
        if (this.abilities != null) {
            builder.abilities(this.abilities);
        }
        return builder;
    }

    public static class AbilitiesComponentBuilder {
        private ArrayList<String> abilities$key;
        private ArrayList<AbilityComponent> abilities$value;

        AbilitiesComponentBuilder() {
        }

        public AbilitiesComponentBuilder ability(String abilityKey, AbilityComponent abilityValue) {
            if (this.abilities$key == null) {
                this.abilities$key = new ArrayList();
                this.abilities$value = new ArrayList();
            }
            this.abilities$key.add(abilityKey);
            this.abilities$value.add(abilityValue);
            return this;
        }

        public AbilitiesComponentBuilder abilities(Map<? extends String, ? extends AbilityComponent> abilities) {
            if (abilities == null) {
                throw new NullPointerException("abilities cannot be null");
            }
            if (this.abilities$key == null) {
                this.abilities$key = new ArrayList();
                this.abilities$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends AbilityComponent> $lombokEntry : abilities.entrySet()) {
                this.abilities$key.add($lombokEntry.getKey());
                this.abilities$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public AbilitiesComponentBuilder clearAbilities() {
            if (this.abilities$key != null) {
                this.abilities$key.clear();
                this.abilities$value.clear();
            }
            return this;
        }

        public AbilitiesComponent build() {
            Map<String, AbilityComponent> abilities;
            switch (this.abilities$key == null ? 0 : this.abilities$key.size()) {
                case 0: {
                    abilities = Collections.emptyMap();
                    break;
                }
                case 1: {
                    abilities = Collections.singletonMap(this.abilities$key.get(0), this.abilities$value.get(0));
                    break;
                }
                default: {
                    abilities = new LinkedHashMap<String, AbilityComponent>(this.abilities$key.size() < 0x40000000 ? 1 + this.abilities$key.size() + (this.abilities$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.abilities$key.size(); ++$i) {
                        abilities.put(this.abilities$key.get($i), this.abilities$value.get($i));
                    }
                    abilities = Collections.unmodifiableMap(abilities);
                }
            }
            return new AbilitiesComponent(abilities);
        }

        public String toString() {
            return "AbilitiesComponent.AbilitiesComponentBuilder(abilities$key=" + String.valueOf(this.abilities$key) + ", abilities$value=" + String.valueOf(this.abilities$value) + ")";
        }
    }
}

