/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityArgument;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityStatArgument;
import it.hurts.sskirillss.relics.config.ConfigHelper;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.command.EnumArgument;

public class RelicsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"relics").requires(sender -> sender.hasPermission(2))).then(Commands.literal((String)"config").then(Commands.literal((String)"reload").executes(context -> {
            ConfigHelper.readConfigs();
            return 1;
        })))).then(Commands.literal((String)"maximize").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            RelicData relicData = relic.getRelicData();
            relic.setLevel(stack, relicData.getLeveling().getMaxLevel());
            for (Map.Entry<String, AbilityData> abilityEntry : relicData.getAbilities().getAbilities().entrySet()) {
                String abilityId = abilityEntry.getKey();
                AbilityData abilityInfo = abilityEntry.getValue();
                relic.setAbilityPoints(stack, abilityId, abilityInfo.getMaxLevel());
                for (Map.Entry<String, StatData> statEntry : abilityInfo.getStats().entrySet()) {
                    relic.setStatInitialValue(stack, abilityId, statEntry.getKey(), (Double)statEntry.getValue().getInitialValue().getValue());
                }
            }
            return 1;
        }))).then(Commands.literal((String)"minimize").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            RelicData relicData = relic.getRelicData();
            relic.setLevel(stack, relicData.getLeveling().getMaxLevel());
            for (Map.Entry<String, AbilityData> abilityEntry : relicData.getAbilities().getAbilities().entrySet()) {
                String abilityId = abilityEntry.getKey();
                relic.setAbilityPoints(stack, abilityId, 0);
                for (Map.Entry<String, StatData> statEntry : abilityEntry.getValue().getStats().entrySet()) {
                    relic.setStatInitialValue(stack, abilityId, statEntry.getKey(), (Double)statEntry.getValue().getInitialValue().getKey());
                }
            }
            return 1;
        }))).then(Commands.literal((String)"level").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            switch (action.ordinal()) {
                case 0: {
                    relic.setLevel(stack, level);
                    break;
                }
                case 1: {
                    relic.addLevel(stack, level);
                    break;
                }
                case 2: {
                    relic.addLevel(stack, -level);
                }
            }
            return 1;
        }))))).then(Commands.literal((String)"experience").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"experience", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int experience = IntegerArgumentType.getInteger((CommandContext)context, (String)"experience");
            switch (action.ordinal()) {
                case 0: {
                    relic.setExperience(stack, experience);
                    break;
                }
                case 1: {
                    relic.addExperience(stack, experience);
                    break;
                }
                case 2: {
                    relic.addExperience(stack, -experience);
                }
            }
            return 1;
        }))))).then(Commands.literal((String)"points").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            switch (action.ordinal()) {
                case 0: {
                    relic.setPoints(stack, points);
                    break;
                }
                case 1: {
                    relic.addPoints(stack, points);
                    break;
                }
                case 2: {
                    relic.addPoints(stack, -points);
                }
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ability").then(Commands.literal((String)"points").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            if (ability.equals("all")) {
                for (String entry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    switch (action.ordinal()) {
                        case 0: {
                            relic.setAbilityPoints(stack, entry, points);
                            break;
                        }
                        case 1: {
                            relic.addAbilityPoints(stack, entry, points);
                            break;
                        }
                        case 2: {
                            relic.addAbilityPoints(stack, entry, -points);
                        }
                    }
                }
            } else {
                switch (action.ordinal()) {
                    case 0: {
                        relic.setAbilityPoints(stack, ability, points);
                        break;
                    }
                    case 1: {
                        relic.addAbilityPoints(stack, ability, points);
                        break;
                    }
                    case 2: {
                        relic.addAbilityPoints(stack, ability, -points);
                    }
                }
            }
            return 1;
        })))))).then(Commands.literal((String)"value").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.argument((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            double value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            switch (action.ordinal()) {
                                case 0: {
                                    relic.setStatInitialValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case 1: {
                                    relic.addStatInitialValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case 2: {
                                    relic.addStatInitialValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    switch (action.ordinal()) {
                        case 0: {
                            relic.setStatInitialValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case 1: {
                            relic.addStatInitialValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case 2: {
                            relic.addStatInitialValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    switch (action.ordinal()) {
                        case 0: {
                            relic.setStatInitialValue(stack, ability, statEntry, value);
                            break;
                        }
                        case 1: {
                            relic.addStatInitialValue(stack, ability, statEntry, value);
                            break;
                        }
                        case 2: {
                            relic.addStatInitialValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                switch (action.ordinal()) {
                    case 0: {
                        relic.setStatInitialValue(stack, ability, stat, value);
                        break;
                    }
                    case 1: {
                        relic.addStatInitialValue(stack, ability, stat, value);
                        break;
                    }
                    case 2: {
                        relic.addStatInitialValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.literal((String)"quality").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.argument((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.argument((String)"quality", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            int quality = IntegerArgumentType.getInteger((CommandContext)context, (String)"quality");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            double value = relic.getStatByQuality(abilityEntry, statEntry, quality);
                            switch (action.ordinal()) {
                                case 0: {
                                    relic.setStatInitialValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case 1: {
                                    relic.addStatInitialValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case 2: {
                                    relic.addStatInitialValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    double value = relic.getStatByQuality(abilityEntry, stat, quality);
                    switch (action.ordinal()) {
                        case 0: {
                            relic.setStatInitialValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case 1: {
                            relic.addStatInitialValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case 2: {
                            relic.addStatInitialValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    double value = relic.getStatByQuality(ability, statEntry, quality);
                    switch (action.ordinal()) {
                        case 0: {
                            relic.setStatInitialValue(stack, ability, statEntry, value);
                            break;
                        }
                        case 1: {
                            relic.addStatInitialValue(stack, ability, statEntry, value);
                            break;
                        }
                        case 2: {
                            relic.addStatInitialValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                double value = relic.getStatByQuality(ability, stat, quality);
                switch (action.ordinal()) {
                    case 0: {
                        relic.setStatInitialValue(stack, ability, stat, value);
                        break;
                    }
                    case 1: {
                        relic.addStatInitialValue(stack, ability, stat, value);
                        break;
                    }
                    case 2: {
                        relic.addStatInitialValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.literal((String)"randomize").then(Commands.argument((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.argument((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            relic.randomizeStat(stack, abilityEntry, statEntry);
                        }
                        continue;
                    }
                    relic.randomizeStat(stack, abilityEntry, stat);
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    relic.randomizeStat(stack, ability, statEntry);
                }
            } else {
                relic.randomizeStat(stack, ability, stat);
            }
            return 1;
        }))))));
    }

    public static enum CommandAction {
        SET,
        ADD,
        TAKE;

    }
}

