/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ScreenUtils {
    public static void drawTexturedTooltipBorder(GuiGraphics guiGraphics, ResourceLocation texture, int width, int height, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Minecraft.getInstance().getTextureManager().bindForSetup(texture);
        int texSize = 19;
        int cornerSize = 9;
        guiGraphics.blit(texture, x, y, cornerSize, cornerSize, 0.0f, 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize, y, width, cornerSize, (float)cornerSize, 0.0f, 1, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize + width, y, cornerSize, cornerSize, (float)(cornerSize + 1), 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x, y + cornerSize, cornerSize, height, 0.0f, (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.blit(texture, x + width + cornerSize, y + cornerSize, cornerSize, height, (float)(cornerSize + 1), (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize, y + cornerSize, width, height, (float)(cornerSize + 1), (float)(cornerSize + 1), 1, 1, texSize, texSize);
        guiGraphics.blit(texture, x, y + height + cornerSize, cornerSize, cornerSize, 0.0f, (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize, y + height + cornerSize, width, cornerSize, (float)cornerSize, (float)(cornerSize + 1), 1, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize + width, y + cornerSize + height, cornerSize, cornerSize, (float)(cornerSize + 1), (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, boolean dropShadow) {
        FormattedCharSequence sequence = text.getVisualOrderText();
        guiGraphics.drawString(font, sequence, x - font.width(sequence) / 2, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color, boolean dropShadow) {
        FormattedCharSequence sequence = text.getVisualOrderText();
        guiGraphics.drawString(font, sequence, x - (float)font.width(sequence) / 2.0f, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color, boolean dropShadow) {
        guiGraphics.drawString(font, text, x - font.width(text) / 2, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow) {
        guiGraphics.drawString(font, text, x - font.width(text) / 2, y, color, dropShadow);
    }

    public static boolean isHovered(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

