/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketExperienceExchange;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class ExperienceExchangeWidget
extends AbstractDescriptionWidget
implements ITickingWidget,
IHoverableWidget {
    private final RelicDescriptionScreen screen;
    private int exchangeSpeed = 1;

    public ExperienceExchangeWidget(int x, int y, RelicDescriptionScreen screen) {
        super(x, y, 12, 16);
        this.screen = screen;
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.screen.stack.getItem();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isExchangeAvailable((Player)this.MC.player, this.screen.stack) || relic.isMaxLevel(this.screen.stack);
    }

    @Override
    public void onPress() {
        if (this.isLocked()) {
            this.exchangeSpeed = 1;
        }
    }

    @Override
    public void onTick() {
        LocalPlayer player = this.MC.player;
        if (player == null) {
            return;
        }
        RandomSource random = player.getRandom();
        if (this.isHoveredOrFocused()) {
            if (this.screen.ticksExisted % 10 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(this.isLocked() ? new Color(100 + random.nextInt(100), 100 + random.nextInt(100), 100 + random.nextInt(100)) : new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + random.nextInt(this.width), this.getY() + random.nextInt(this.height), 0.15f + random.nextFloat() * 0.25f, 100 + random.nextInt(50)));
            }
            this.screen.gatherData();
        }
        if (this.isLocked() || !this.isFocused() || !this.isHovered()) {
            return;
        }
        if (player.experienceLevel > 0 || player.totalExperience > 0) {
            if (this.screen.ticksExisted % 2 == 0) {
                ++this.exchangeSpeed;
            }
            NetworkHandler.sendToServer(new PacketExperienceExchange(this.screen.pos, (int)Math.ceil((float)this.exchangeSpeed / 4.0f)));
            this.MC.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)(1.0f + (float)this.exchangeSpeed * 0.02f)));
        }
    }

    public void onRelease(double pMouseX, double pMouseY) {
        this.setFocused(false);
        this.exchangeSpeed = 1;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        TextureManager manager = this.MC.getTextureManager();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.bindForSetup(RelicDescriptionScreen.TEXTURE);
        boolean isLocked = this.isLocked();
        guiGraphics.blit(RelicDescriptionScreen.TEXTURE, this.getX(), this.getY(), isLocked ? 407.0f : 394.0f, 1.0f, this.width, this.height, 512, 512);
        if (this.isHovered) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/exchange_highlight_" + (isLocked ? "locked" : "unlocked") + ".png")));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(guiGraphics.pose(), this.getX() + 6, this.getY() + 7, 32.0f, 384.0f, 32.0f, 32.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
            RenderSystem.disableBlend();
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        RelicData data = relic.getRelicData();
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        int cost = relic.getExchangeCost(this.screen.stack);
        int experience = this.MC.player.totalExperience;
        MutableComponent negativeStatus = Component.translatable((String)"tooltip.relics.relic.status.negative").withStyle(ChatFormatting.RED);
        MutableComponent positiveStatus = Component.translatable((String)"tooltip.relics.relic.status.positive").withStyle(ChatFormatting.GREEN);
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.exchange.description").withStyle(ChatFormatting.BOLD), Component.literal((String)" ")});
        if (relic.isMaxLevel(this.screen.stack)) {
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.exchange.locked")));
        } else {
            entries.add(Component.translatable((String)"tooltip.relics.relic.exchange.cost", (Object[])new Object[]{cost, cost >= experience ? negativeStatus : positiveStatus}));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = (this.MC.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round(tooltip.size() * 5);
        int renderX = this.getX() + this.width + 1;
        int renderY = mouseY - height / 2 - 9;
        ScreenUtils.drawTexturedTooltipBorder(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.MC.font, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
            yOff += 5;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
    }
}

