/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class AbilityCardIconWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final RelicDescriptionScreen screen;
    private final String ability;
    private float scale = 1.0f;

    public AbilityCardIconWidget(int x, int y, RelicDescriptionScreen screen, String ability) {
        super(x, y, 30, 46);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public void onPress() {
        this.MC.setScreen((Screen)new AbilityDescriptionScreen(this.screen.pos, this.screen.stack, this.ability));
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TextureManager manager = this.MC.getTextureManager();
        PoseStack poseStack = guiGraphics.pose();
        boolean canUse = relic.canUseAbility(this.screen.stack, this.ability);
        boolean canUpgrade = relic.mayPlayerUpgrade((Player)this.MC.player, this.screen.stack, this.ability);
        ResourceLocation card = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/cards/" + BuiltInRegistries.ITEM.getKey((Object)this.screen.stack.getItem()).getPath() + "/" + (String)relic.getAbilityData(this.ability).getIcon().apply((Object)this.MC.player, (Object)this.screen.stack, (Object)this.ability) + ".png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
        manager.bindForSetup(card);
        poseStack.pushPose();
        poseStack.scale(this.scale, this.scale, this.scale);
        poseStack.translate(((float)this.getX() + (float)this.width / 2.0f) / this.scale, ((float)this.getY() + (float)this.height / 2.0f) / this.scale, 0.0f);
        if (!canUse) {
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)this.scale);
        } else if (canUpgrade) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)this.scale);
        }
        guiGraphics.blit(card, -11, -16, 0.0f, 0.0f, 20, 29, 20, 29);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.bindForSetup(RelicDescriptionScreen.TEXTURE);
        if (canUse) {
            guiGraphics.blit(RelicDescriptionScreen.TEXTURE, -(this.width / 2), -(this.height / 2), 302.0f, 61.0f, this.width, this.height, 512, 512);
            if (this.isHovered()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/card_highlight_unlocked.png"));
                RenderSystem.enableBlend();
                RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, 0.0f, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
                RenderSystem.disableBlend();
            }
        } else {
            guiGraphics.blit(RelicDescriptionScreen.TEXTURE, -(this.width / 2) - 1, -(this.height / 2), 333.0f, 61.0f, this.width + 1, this.height, 512, 512);
            if (this.isHovered()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/card_highlight_locked.png"));
                RenderSystem.enableBlend();
                RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, 0.0f, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
                RenderSystem.disableBlend();
            }
        }
        if (canUpgrade) {
            ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/upgrade_available.png");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
            manager.bindForSetup(icon);
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(poseStack, -1.0f, -1.0f, 32.0f, 256.0f, 32.0f, 32.0f, 0.9f + (float)(Math.sin(((float)this.screen.ticksExisted + pPartialTick) * 0.25f) * (double)0.025f), AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 20));
            RenderSystem.disableBlend();
        }
        int xOff = 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.bindForSetup(RelicDescriptionScreen.TEXTURE);
        for (int i = 1; i < relic.getAbilityQuality(this.screen.stack, this.ability) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            guiGraphics.blit(RelicDescriptionScreen.TEXTURE, -(this.width / 2) + xOff + 2, -(this.height / 2) + 38, (float)((canUse ? 302 : 334) + (isAliquot ? 0 : 2)), 108.0f, isAliquot ? 2 : 3, 4, 512, 512);
            xOff += isAliquot ? 2 : 3;
        }
        MutableComponent title = Component.literal((String)String.valueOf(relic.getAbilityPoints(this.screen.stack, this.ability))).withStyle(ChatFormatting.BOLD);
        float textScale = 0.5f;
        poseStack.scale(textScale, textScale, textScale);
        guiGraphics.drawString(this.MC.font, (Component)title, -((this.width + 1) / 2) - this.MC.font.width((FormattedText)title) / 2 + 13, -(this.height / 2) - 19, 16764566, true);
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        float maxScale = 1.1f;
        float minScale = 1.0f;
        RandomSource random = this.MC.player.getRandom();
        if (relic.mayPlayerUpgrade((Player)this.MC.player, this.screen.stack, this.ability) && this.screen.ticksExisted % 7 == 0) {
            ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + 5 + random.nextInt(18), this.getY() + 18, 0.15f + random.nextFloat() * 0.25f, 100 + random.nextInt(50)));
        }
        if (this.isHovered()) {
            if (this.screen.ticksExisted % 3 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(relic.canUseAbility(this.screen.stack, this.ability) ? new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0) : new Color(100 + random.nextInt(100), 100 + random.nextInt(100), 100 + random.nextInt(100)), this.getX() + random.nextInt(this.width), this.getY() - 1, 0.15f + random.nextFloat() * 0.25f, 100 + random.nextInt(50)));
            }
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + (maxScale - this.scale) * 0.25f);
            }
        } else if (this.scale != minScale) {
            this.scale = Math.max(minScale, this.scale - 0.025f);
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int requiredLevel;
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityData data = relic.getAbilityData(this.ability);
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 110;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.screen.stack.getItem()).getPath() + ".ability." + this.ability)).withStyle(ChatFormatting.BOLD)});
        int level = relic.getLevel(this.screen.stack);
        if (level < (requiredLevel = data.getRequiredLevel())) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.ability.tooltip.low_level", (Object[])new Object[]{requiredLevel, Component.translatable((String)"tooltip.relics.relic.status.negative").withStyle(ChatFormatting.RED)})));
        } else if (data.getMaxLevel() == 0) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.ability.tooltip.no_stats")));
        } else if (relic.mayPlayerUpgrade((Player)this.MC.player, this.screen.stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.ability.tooltip.ready_to_upgrade", (Object[])new Object[]{Component.translatable((String)"tooltip.relics.relic.status.positive").withStyle(ChatFormatting.GREEN)})));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.MC.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 4.5f);
        int y = this.getHeight() / 2;
        poseStack.scale(this.scale, this.scale, this.scale);
        poseStack.translate(((float)this.getX() + (float)this.getWidth() / 2.0f) / this.scale, ((float)this.getY() + (float)this.getHeight() / 2.0f) / this.scale, 0.0f);
        ScreenUtils.drawTexturedTooltipBorder(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/tooltip/border/paper.png"), renderWidth, height, -((renderWidth + 19) / 2), y);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.MC.font, entry, -(this.MC.font.width(entry) / 2), (y + yOff + 9) * 2, 4269832, false);
            yOff += 5;
            poseStack.popPose();
        }
    }
}

