/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.data;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.sskirillss.relics.client.screen.description.data.base.ParticleData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class ExperienceParticleData
extends ParticleData {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/experience_particle.png");

    public ExperienceParticleData(Color color, float xStart, float yStart, float scale, int lifeTime) {
        super(TEXTURE, color, xStart, yStart, scale, lifeTime);
    }

    @Override
    public void tick(Screen screen) {
        LocalPlayer player = screen.getMinecraft().player;
        if (player == null) {
            return;
        }
        RandomSource random = player.getRandom();
        this.setX((float)((double)this.getX() + Math.sin((float)this.getLifeTime() * 0.15f) * (double)(0.1f + random.nextFloat() * 0.25f)));
        this.setY(this.getY() - 0.2f);
    }

    @Override
    public void render(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft MC = screen.getMinecraft();
        float lifePercentage = 1.0f - (float)(this.getMaxLifeTime() - this.getLifeTime()) / 100.0f;
        RenderSystem.setShaderColor((float)((float)this.getColor().getRed() / 255.0f), (float)((float)this.getColor().getGreen() / 255.0f), (float)((float)this.getColor().getBlue() / 255.0f), (float)(1.0f * lifePercentage));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        MC.getTextureManager().getTexture(this.getTexture()).setBlurMipmap(true, false);
        RenderUtils.renderTextureFromCenter(guiGraphics.pose(), this.getX(), this.getY(), 8.0f, 8.0f, this.getScale() * lifePercentage);
        MC.getTextureManager().getTexture(this.getTexture()).restoreLastBlurMipmap();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }
}

