/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.AbilityCardIconWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.ExperienceExchangeWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RelicDescriptionScreen
extends Screen
implements IAutoScaledScreen {
    private final Minecraft MC = Minecraft.getInstance();
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/relic_background.png");
    public final BlockPos pos;
    public ItemStack stack;
    public int backgroundHeight = 171;
    public int backgroundWidth = 268;
    public int ticksExisted;

    public RelicDescriptionScreen(BlockPos pos) {
        super((Component)Component.empty());
        this.pos = pos;
        this.gatherData();
    }

    public void gatherData() {
        ClientLevel level = this.MC.level;
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (!(blockEntity instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        ItemStack stack = tile.getStack();
        if (!(stack.getItem() instanceof IRelicItem)) {
            return;
        }
        this.stack = stack;
    }

    protected void init() {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TextureManager manager = this.MC.getTextureManager();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.bindForSetup(TEXTURE);
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        int step = 0;
        for (Map.Entry<String, AbilityData> ability : relic.getRelicData().getAbilities().getAbilities().entrySet()) {
            this.addRenderableWidget((GuiEventListener)new AbilityCardIconWidget(x + 41 + step, y + 105, this, ability.getKey()));
            step += 39;
        }
        this.addRenderableWidget((GuiEventListener)new ExperienceExchangeWidget(x + 239, y + 72, this));
    }

    public void tick() {
        Item item;
        super.tick();
        LocalPlayer player = this.MC.player;
        if (player == null) {
            return;
        }
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (!(blockEntity instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        this.stack = tile.getStack();
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        ++this.ticksExisted;
        RandomSource random = player.getRandom();
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        if (this.ticksExisted % 3 == 0) {
            int xOff;
            float percentage;
            int sourceWidth;
            int maxWidth;
            int xOff2;
            int relicLevel = relic.getLevel(this.stack);
            int sourceWidth2 = 206;
            float percentage2 = relic.isMaxLevel(this.stack) ? 100.0f : (float)relic.getExperience(this.stack) / ((float)relic.getExperienceBetweenLevels(this.stack, relicLevel, relicLevel + 1) / 100.0f);
            int maxWidth2 = (int)((float)sourceWidth2 * (percentage2 / 100.0f));
            if (maxWidth2 > 0 && (xOff2 = random.nextInt(sourceWidth2)) <= maxWidth2) {
                ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), x + 30 + xOff2, y + 73, 0.15f + random.nextFloat() * 0.25f, 100 + random.nextInt(50)));
            }
            if ((maxWidth = (int)((float)(sourceWidth = 206) * ((percentage = (float)((int)((float)player.totalExperience / ((float)player.totalExperience / player.experienceProgress / 100.0f)))) / 100.0f))) > 0 && (xOff = random.nextInt(sourceWidth)) <= maxWidth) {
                ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(100 + random.nextInt(50), 200 + random.nextInt(50), 0), x + 30 + xOff, y + 86, 0.15f + random.nextFloat() * 0.25f, 100 + random.nextInt(50)));
            }
        }
        if (this.ticksExisted % 10 == 0 && relic.getPoints(this.stack) > 0) {
            ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), x + this.backgroundWidth + 15 + random.nextInt(16), y + 8 + random.nextInt(10), 0.15f + random.nextFloat() * 0.25f, 100 + random.nextInt(50)));
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int renderY;
        int renderX;
        int height;
        int entryWidth;
        ArrayList entries;
        int renderWidth;
        ArrayList tooltip;
        IRelicItem relic;
        LocalPlayer player;
        block23: {
            block22: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                player = this.MC.player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block22;
                relic = (IRelicItem)item;
                if (player != null) break block23;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        PoseStack pPoseStack = guiGraphics.pose();
        TextureManager manager = this.MC.getTextureManager();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.bindForSetup(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, texWidth, texHeight);
        int level = relic.getLevel(this.stack);
        float percentage = (float)relic.getExperience(this.stack) / ((float)relic.getExperienceBetweenLevels(this.stack, level, level + 1) / 100.0f);
        boolean isMaxLevel = relic.isMaxLevel(this.stack);
        guiGraphics.blit(TEXTURE, x + 30, y + 72, 302.0f, 144.0f, isMaxLevel ? 206 : (int)Math.ceil(percentage / 100.0f * 206.0f), 3, texWidth, texHeight);
        boolean hoveredRelicExperience = ScreenUtils.isHovered(x + 30, y + 72, 206, 3, pMouseX, pMouseY);
        if (hoveredRelicExperience) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/relic_experience_highlight.png"));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(guiGraphics.pose(), (float)x + 133.0f, (float)y + 73.5f, 210.0f, 98.0f, 210.0f, 7.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2));
            RenderSystem.disableBlend();
        }
        percentage = (float)player.totalExperience / ((float)player.totalExperience / player.experienceProgress / 100.0f);
        guiGraphics.blit(TEXTURE, x + 30, y + 85, 302.0f, 148.0f, (int)Math.ceil(percentage / 100.0f * 206.0f), 3, texWidth, texHeight);
        boolean hoveredVanillaExperience = ScreenUtils.isHovered(x + 30, y + 85, 206, 3, pMouseX, pMouseY);
        if (hoveredVanillaExperience) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/experience_highlight.png"));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(guiGraphics.pose(), (float)x + 133.0f, (float)y + 86.5f, 210.0f, 98.0f, 210.0f, 7.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2));
            RenderSystem.disableBlend();
        }
        ResourceLocation background = relic.getStyleData().getBackground();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)background);
        float color = (float)(0.75 + Math.sin((float)player.tickCount * 0.1f) * (double)0.05f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        guiGraphics.blit(background, x + 18, y + 15, 0.0f, 0.0f, 34, 34, 34, 34);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, x + 13, y + 10, 302.0f, 5.0f, 46, 55, texWidth, texHeight);
        pPoseStack.pushPose();
        float scale = 1.5f;
        pPoseStack.translate((float)(x + 23), (float)(y + 20), 0.0f);
        pPoseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)255.0f, (float)255.0f, (float)255.0f, (float)1.0f);
        guiGraphics.renderItem(this.stack, 1, 0);
        guiGraphics.renderItem(this.stack, -1, 0);
        guiGraphics.renderItem(this.stack, 0, 1);
        guiGraphics.renderItem(this.stack, 0, -1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.renderItem(this.stack, 0, 0);
        pPoseStack.popPose();
        int xOff = 0;
        for (int i = 1; i < relic.getRelicQuality(this.stack) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            guiGraphics.blit(TEXTURE, x + 15 + xOff, y + 51, (float)(353 + (isAliquot ? 0 : 5)), 3.0f, isAliquot ? 5 : 4, 9, texWidth, texHeight);
            xOff += isAliquot ? 5 : 3;
        }
        MutableComponent name = Component.literal((String)this.stack.getDisplayName().getString().replace("[", "").replace("]", "")).withStyle(ChatFormatting.BOLD);
        pPoseStack.pushPose();
        pPoseStack.scale(0.5f, 0.5f, 1.0f);
        guiGraphics.drawString(this.MC.font, (Component)name, (x + 62) * 2, (y + 21) * 2, 4269832, false);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.scale(0.75f, 0.75f, 0.75f);
        MutableComponent experience = isMaxLevel ? Component.translatable((String)"tooltip.relics.relic.max_level") : Component.literal((String)String.valueOf(level));
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, ((float)x + 135.75f) * 1.33f, (float)(y + 71) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, ((float)x + 134.25f) * 1.33f, (float)(y + 71) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 71.75f) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 70.25f) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, (float)(y + 71) * 1.33f, 0xFFF500, false);
        experience = Component.literal((String)String.valueOf(player.experienceLevel));
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, ((float)x + 135.75f) * 1.33f, (float)(y + 84) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, ((float)x + 134.25f) * 1.33f, (float)(y + 84) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 84.75f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 83.25f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, (float)(y + 84) * 1.33f, 8322080, false);
        pPoseStack.popPose();
        String registryName = BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath();
        pPoseStack.pushPose();
        pPoseStack.scale(0.5f, 0.5f, 1.0f);
        int yOff = 9;
        for (FormattedCharSequence line : this.MC.font.split((FormattedText)Component.translatable((String)("tooltip.relics." + registryName + ".description")), 350)) {
            guiGraphics.drawString(this.MC.font, line, (x + 62) * 2, (y + 26) * 2 + yOff, 4269832, false);
            yOff += 9;
        }
        pPoseStack.popPose();
        int points = relic.getPoints(this.stack);
        if (points > 0) {
            pPoseStack.pushPose();
            MutableComponent value = Component.literal((String)String.valueOf(points)).withStyle(ChatFormatting.BOLD);
            ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/leveling_point.png");
            manager.bindForSetup(icon);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
            guiGraphics.blit(icon, x + this.backgroundWidth + 5, y - 2, 0.0f, 0.0f, 50, 31, 50, 31);
            guiGraphics.drawString(this.MC.font, (Component)value, x + this.backgroundWidth + 39 - this.MC.font.width((FormattedText)value) / 2, y + 10, 16764566);
            pPoseStack.popPose();
        }
        if (hoveredRelicExperience) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 10.0f);
            tooltip = Lists.newArrayList();
            int maxWidth = 200;
            renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.relic_experience.title").withStyle(ChatFormatting.BOLD)});
            if (!isMaxLevel) {
                entries.add(Component.literal((String)" "));
                entries.add(Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)"tooltip.relics.relic.relic_experience.current_amount", (Object[])new Object[]{relic.getExperience(this.stack), relic.getExperienceBetweenLevels(this.stack, level, level + 1), MathUtils.round((float)relic.getExperience(this.stack) / ((float)relic.getExperienceBetweenLevels(this.stack, level, level + 1) / 100.0f), 1)})));
            }
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.font.width((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
            }
            height = Math.round((float)tooltip.size() * 4.5f);
            renderX = pMouseX - 9 - renderWidth / 2;
            renderY = y + 77;
            ScreenUtils.drawTexturedTooltipBorder(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                guiGraphics.drawString(this.MC.font, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
                yOff += 5;
            }
            pPoseStack.scale(1.0f, 1.0f, 1.0f);
            pPoseStack.popPose();
        }
        if (hoveredVanillaExperience) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 10.0f);
            tooltip = Lists.newArrayList();
            int maxWidth = 200;
            renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.vanilla_experience.title").withStyle(ChatFormatting.BOLD), Component.literal((String)" "), Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)"tooltip.relics.relic.vanilla_experience.current_amount", (Object[])new Object[]{player.totalExperience - EntityUtils.getTotalExperienceForLevel(player.experienceLevel), EntityUtils.getTotalExperienceForLevel(player.experienceLevel + 1) - EntityUtils.getTotalExperienceForLevel(player.experienceLevel), MathUtils.round(player.experienceProgress * 100.0f, 1)})), Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)"tooltip.relics.relic.vanilla_experience.total_amount", (Object[])new Object[]{player.totalExperience}))});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.font.width((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
            }
            height = Math.round((float)tooltip.size() * 4.5f);
            renderX = pMouseX - 9 - renderWidth / 2;
            renderY = y + 90;
            ScreenUtils.drawTexturedTooltipBorder(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                guiGraphics.drawString(this.MC.font, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
                yOff += 5;
            }
            pPoseStack.scale(1.0f, 1.0f, 1.0f);
            pPoseStack.popPose();
        }
        if (points > 0 && ScreenUtils.isHovered(x + this.backgroundWidth + 5, y - 2, 50, 31, pMouseX, pMouseY)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/leveling_point_highlight.png"));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(guiGraphics.pose(), x + this.backgroundWidth + 5 + 25, y - 2 + 15, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
            RenderSystem.disableBlend();
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 10.0f);
            tooltip = Lists.newArrayList();
            int maxWidth = 200;
            renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.leveling_points.title").withStyle(ChatFormatting.BOLD)});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.font.width((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
            }
            int height2 = Math.round((float)tooltip.size() * 4.5f);
            int renderX2 = pMouseX + 1;
            renderY = pMouseY + 1;
            ScreenUtils.drawTexturedTooltipBorder(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/tooltip/border/paper.png"), renderWidth, height2, renderX2, renderY);
            yOff = 0;
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                guiGraphics.drawString(this.MC.font, entry, (renderX2 + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
                yOff += 5;
            }
            pPoseStack.scale(1.0f, 1.0f, 1.0f);
            pPoseStack.popPose();
        }
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.MC.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }
}

