/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityRerollButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityResetButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityUpgradeButtonWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.components.StatComponent;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends Screen
implements IAutoScaledScreen {
    private final Minecraft MC = Minecraft.getInstance();
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability_background.png");
    public final BlockPos pos;
    public ItemStack stack;
    public final String ability;
    public int backgroundHeight = 171;
    public int backgroundWidth = 268;
    public AbilityUpgradeButtonWidget upgradeButton;
    public AbilityRerollButtonWidget rerollButton;
    public AbilityResetButtonWidget resetButton;
    public int ticksExisted;

    public AbilityDescriptionScreen(BlockPos pos, ItemStack stack, String ability) {
        super((Component)Component.empty());
        this.pos = pos;
        this.stack = stack;
        this.ability = ability;
    }

    protected void init() {
        if (this.stack == null || !(this.stack.getItem() instanceof IRelicItem)) {
            return;
        }
        TextureManager manager = this.MC.getTextureManager();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.bindForSetup(TEXTURE);
        this.upgradeButton = new AbilityUpgradeButtonWidget((this.width - this.backgroundWidth) / 2 + 233, (this.height - this.backgroundHeight) / 2 + 104, this, this.ability);
        this.rerollButton = new AbilityRerollButtonWidget((this.width - this.backgroundWidth) / 2 + 233, (this.height - this.backgroundHeight) / 2 + 122, this, this.ability);
        this.resetButton = new AbilityResetButtonWidget((this.width - this.backgroundWidth) / 2 + 233, (this.height - this.backgroundHeight) / 2 + 140, this, this.ability);
        this.addRenderableWidget((GuiEventListener)this.upgradeButton);
        this.addRenderableWidget((GuiEventListener)this.rerollButton);
        this.addRenderableWidget((GuiEventListener)this.resetButton);
    }

    public void tick() {
        int xOff;
        int percentage;
        int sourceWidth;
        int maxWidth;
        super.tick();
        LocalPlayer player = this.MC.player;
        if (player == null) {
            return;
        }
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (!(blockEntity instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        this.stack = tile.getStack();
        if (this.stack == null || !(this.stack.getItem() instanceof IRelicItem)) {
            return;
        }
        ++this.ticksExisted;
        RandomSource random = player.getRandom();
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        if (this.ticksExisted % 3 == 0 && (maxWidth = (int)((float)(sourceWidth = 206) * ((float)(percentage = (int)((float)player.totalExperience / ((float)player.totalExperience / player.experienceProgress / 100.0f))) / 100.0f))) > 0 && (xOff = random.nextInt(sourceWidth)) <= maxWidth) {
            ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(100 + random.nextInt(50), 200 + random.nextInt(50), 0), x + 30 + xOff, y + 82, 0.15f + random.nextFloat() * 0.25f, 100 + random.nextInt(50)));
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int renderY;
        int entryWidth;
        ArrayList entries;
        IRelicItem relic;
        LocalPlayer player;
        block29: {
            block28: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                player = this.MC.player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block28;
                relic = (IRelicItem)item;
                if (player != null) break block29;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        AbilityData abilityData = relic.getAbilityData(this.ability);
        if (abilityData == null) {
            return;
        }
        PoseStack pPoseStack = guiGraphics.pose();
        TextureManager manager = this.MC.getTextureManager();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.bindForSetup(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, texWidth, texHeight);
        int percentage = (int)((float)player.totalExperience / ((float)player.totalExperience / player.experienceProgress / 100.0f));
        guiGraphics.blit(TEXTURE, x + 30, y + 82, 301.0f, 124.0f, (int)Math.ceil((float)percentage / 100.0f * 206.0f), 3, texWidth, texHeight);
        boolean hoveredVanillaExperience = ScreenUtils.isHovered(x + 30, y + 81, 206, 3, pMouseX, pMouseY);
        if (hoveredVanillaExperience) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/experience_highlight.png"));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(guiGraphics.pose(), (float)x + 134.0f, (float)y + 83.5f, 210.0f, 98.0f, 210.0f, 7.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2));
            RenderSystem.disableBlend();
        }
        pPoseStack.pushPose();
        pPoseStack.scale(0.75f, 0.75f, 0.75f);
        MutableComponent experience = Component.literal((String)String.valueOf(player.experienceLevel));
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, ((float)x + 135.75f) * 1.33f, (float)(y + 81) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, ((float)x + 134.25f) * 1.33f, (float)(y + 81) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 81.75f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 80.25f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(guiGraphics, this.MC.font, (Component)experience, (float)(x + 135) * 1.33f, (float)(y + 81) * 1.33f, 8322080, false);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        int level = relic.getAbilityPoints(this.stack, this.ability);
        int maxLevel = abilityData.getMaxLevel() == -1 ? relicData.getLeveling().getMaxLevel() / abilityData.getRequiredPoints() : abilityData.getMaxLevel();
        MutableComponent name = Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + this.ability));
        if (!abilityData.getStats().isEmpty()) {
            name.append((Component)Component.translatable((String)"tooltip.relics.relic.ability.level", (Object[])new Object[]{level, maxLevel == -1 ? "\u221e" : Integer.valueOf(maxLevel)}));
        }
        guiGraphics.drawString(this.MC.font, (Component)name.withStyle(ChatFormatting.BOLD), (x + 62) * 2, (y + 20) * 2 - 1, 4269832, false);
        List lines = this.MC.font.split((FormattedText)Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + this.ability + ".description")), 350);
        for (int i = 0; i < lines.size(); ++i) {
            guiGraphics.drawString(this.MC.font, (FormattedCharSequence)lines.get(i), (x + 62) * 2, (y + 28 + i * 5) * 2, 4269832, false);
        }
        pPoseStack.popPose();
        int yOff = 0;
        int xOff = 0;
        boolean isLocked = !relic.canUseAbility(this.stack, this.ability);
        boolean isHoveredUpgrade = !isLocked && this.upgradeButton.isHovered();
        boolean isHoveredReroll = !isLocked && this.rerollButton.isHovered();
        boolean isHoveredReset = !isLocked && this.resetButton.isHovered();
        for (Map.Entry<String, StatComponent> entry : relic.getAbilityComponent(this.stack, this.ability).stats().entrySet()) {
            int i;
            String stat = entry.getKey();
            StatComponent statComponent = entry.getValue();
            StatData statData = relic.getStatData(this.ability, stat);
            if (statData == null) continue;
            MutableComponent cost = Component.literal((String)String.valueOf(statData.getFormatValue().apply(relic.getStatValue(this.stack, this.ability, stat))));
            if (isHoveredUpgrade && level < maxLevel) {
                cost.append(" \u27a0 " + String.valueOf(statData.getFormatValue().apply(relic.getStatValue(this.stack, this.ability, stat, level + 1))));
            }
            if (isHoveredReroll) {
                cost.append(" \u27a0 ").append((Component)Component.literal((String)"X.XXX").withStyle(ChatFormatting.OBFUSCATED));
            }
            if (isHoveredReset && level > 0) {
                cost.append(" \u27a0 " + String.valueOf(statData.getFormatValue().apply(relic.getStatValue(this.stack, this.ability, stat, 0))));
            }
            pPoseStack.pushPose();
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.MC.font, (Component)Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + this.ability + ".stat." + stat + ".title")), (x + 35) * 2, (y + yOff + 102) * 2, 4269832, false);
            guiGraphics.drawString(this.MC.font, (Component)Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + this.ability + ".stat." + stat + ".value"), (Object[])new Object[]{cost})), (x + 40) * 2, (y + yOff + 107) * 2, 4269832, false);
            pPoseStack.popPose();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            for (i = 0; i < 5; ++i) {
                guiGraphics.blit(TEXTURE, x + xOff + 202, y + yOff + 102, 398.0f, 15.0f, 4, 4, 512, 512);
                xOff += 5;
            }
            xOff = 0;
            manager.bindForSetup(TEXTURE);
            for (i = 1; i < relic.getStatQuality(this.stack, this.ability, stat) + 1; ++i) {
                boolean isAliquot = i % 2 == 1;
                guiGraphics.blit(TEXTURE, x + xOff + 202, y + yOff + 102, (float)((isLocked ? 407 : 398) + (isAliquot ? 0 : 2)), 10.0f, isAliquot ? 2 : 3, 4, 512, 512);
                xOff += isAliquot ? 2 : 3;
            }
            yOff += 14;
            xOff = 0;
        }
        ResourceLocation card = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/cards/" + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + "/" + (String)abilityData.getIcon().apply((Object)player, (Object)this.stack, (Object)this.ability) + ".png"));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
        manager.bindForSetup(card);
        if (GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097) == 29) {
            if (isLocked) {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
            guiGraphics.blit(card, x + 17, y + 11, 36, 50, 0.0f, 0.0f, 20, 29, 20, 29);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.bindForSetup(TEXTURE);
        if (isLocked) {
            guiGraphics.blit(TEXTURE, x + 12, y + 7, 349.0f, 0.0f, 47, 69, texWidth, texHeight);
        } else {
            guiGraphics.blit(TEXTURE, x + 13, y + 7, 302.0f, 0.0f, 46, 69, texWidth, texHeight);
        }
        for (int i = 1; i < relic.getAbilityQuality(this.stack, this.ability) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            guiGraphics.blit(TEXTURE, x + 15 + xOff, y + 63, (float)((isLocked ? 407 : 397) + (isAliquot ? 0 : 5)), 0.0f, isAliquot ? 5 : 4, 9, texWidth, texHeight);
            xOff += isAliquot ? 5 : 3;
        }
        int points = relic.getPoints(this.stack);
        if (points > 0) {
            pPoseStack.pushPose();
            MutableComponent value = Component.literal((String)String.valueOf(points)).withStyle(ChatFormatting.BOLD);
            ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/leveling_point.png");
            manager.bindForSetup(icon);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
            guiGraphics.blit(icon, x + this.backgroundWidth + 5, y - 2, 0.0f, 0.0f, 50, 31, 50, 31);
            guiGraphics.drawString(this.MC.font, (Component)value, x + this.backgroundWidth + 39 - this.MC.font.width((FormattedText)value) / 2, y + 10, 16764566);
            pPoseStack.popPose();
        }
        if (hoveredVanillaExperience) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 10.0f);
            ArrayList tooltip = Lists.newArrayList();
            int maxWidth = 200;
            int renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.vanilla_experience.title").withStyle(ChatFormatting.BOLD), Component.literal((String)" "), Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)"tooltip.relics.relic.vanilla_experience.current_amount", (Object[])new Object[]{player.totalExperience - EntityUtils.getTotalExperienceForLevel(player.experienceLevel), EntityUtils.getTotalExperienceForLevel(player.experienceLevel + 1) - EntityUtils.getTotalExperienceForLevel(player.experienceLevel), MathUtils.round(player.experienceProgress * 100.0f, 1)})), Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)"tooltip.relics.relic.vanilla_experience.total_amount", (Object[])new Object[]{player.totalExperience}))});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.font.width((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
            }
            int height = Math.round((float)tooltip.size() * 4.5f);
            int renderX = pMouseX - 9 - renderWidth / 2;
            renderY = y + 87;
            ScreenUtils.drawTexturedTooltipBorder(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                guiGraphics.drawString(this.MC.font, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
                yOff += 5;
            }
            pPoseStack.scale(1.0f, 1.0f, 1.0f);
            pPoseStack.popPose();
        }
        if (points > 0 && ScreenUtils.isHovered(x + this.backgroundWidth + 5, y - 2, 50, 31, pMouseX, pMouseY)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/leveling_point_highlight.png"));
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(guiGraphics.pose(), x + this.backgroundWidth + 5 + 25, y - 2 + 15, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
            RenderSystem.disableBlend();
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 10.0f);
            ArrayList tooltip = Lists.newArrayList();
            int maxWidth = 200;
            int renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.leveling_points.title").withStyle(ChatFormatting.BOLD)});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.font.width((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
            }
            int height = Math.round((float)tooltip.size() * 4.5f);
            int renderX = pMouseX + 1;
            renderY = pMouseY + 1;
            ScreenUtils.drawTexturedTooltipBorder(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                guiGraphics.drawString(this.MC.font, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
                yOff += 5;
            }
            pPoseStack.scale(1.0f, 1.0f, 1.0f);
            pPoseStack.popPose();
        }
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.MC.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        this.MC.setScreen((Screen)new RelicDescriptionScreen(this.pos));
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }
}

