/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.SporeModel;
import it.hurts.sskirillss.relics.entities.SporeEntity;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SporeRenderer
extends EntityRenderer<SporeEntity> {
    public SporeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(SporeEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ItemStack stack;
        Item item;
        float time = (float)entityIn.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, Math.pow(Math.log10(1.0f + entityIn.getSize()), 0.3333333333333333) / 4.0, 0.0);
        if (!entityIn.isStuck()) {
            float speed = 15.0f;
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(time * speed));
            matrixStackIn.mulPose(Axis.XN.rotationDegrees(time * speed));
        }
        if ((item = (stack = entityIn.getStack()).getItem()) instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            double inlinedSize = Math.pow(Math.log10(1.0f + entityIn.getSize()), 0.3333333333333333);
            int maxLifetime = (int)Math.round(relic.getStatValue(entityIn.getStack(), "spore", "duration") * 20.0);
            int lifetime = entityIn.getLifetime();
            float scale = (float)(inlinedSize + Math.abs(Math.sin(((float)entityIn.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks)) * 0.2f)) * (double)0.05f + (double)(lifetime >= maxLifetime - 20 ? (float)((double)((float)(20 - (maxLifetime - lifetime)) + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks)) * (inlinedSize * (double)0.035f)) : 0.0f));
            matrixStackIn.scale(scale, scale, scale);
        }
        new SporeModel().renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/spore.png"))), packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(SporeEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/spore.png");
    }
}

