/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.ShadowSawModel;
import it.hurts.sskirillss.relics.entities.ShadowSawEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShadowSawRenderer
extends EntityRenderer<ShadowSawEntity> {
    public ShadowSawRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(ShadowSawEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float time = (float)entityIn.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, 1.0f, 0.0f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(time * 30.0f));
        matrixStackIn.mulPose(Axis.ZP.rotation((float)(Math.sin(time) * (double)0.3f) * 0.1f));
        matrixStackIn.translate(0.0, Math.sin(time * 0.1f) * (double)0.05f, 0.0);
        matrixStackIn.scale(1.5f, -1.0f, 1.5f);
        new ShadowSawModel().renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/shadow_saw.png"))), packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(ShadowSawEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/shadow_saw.png");
    }
}

