/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import com.mojang.serialization.MapCodec;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.TickerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchingTableBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public ResearchingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ResearchingTableTile tile;
        ItemStack stack;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = worldIn.getBlockEntity(pos)) instanceof ResearchingTableTile && (stack = (tile = (ResearchingTableTile)blockEntity).getStack()) != null && !stack.isEmpty()) {
            worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openGui(BlockPos pos) {
        Minecraft.getInstance().setScreen((Screen)new RelicDescriptionScreen(pos));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TickerUtils.getTicker(type, (BlockEntityType)TileRegistry.RESEARCHING_TABLE.get(), ResearchingTableTile::tick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ResearchingTableTile(pos, state);
    }

    public void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return ResearchingTableBlock.simpleCodec(ResearchingTableBlock::new);
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
            BlockPos pos;
            InteractionHand hand = event.getHand();
            if (hand != InteractionHand.MAIN_HAND) {
                return;
            }
            Level level = event.getLevel();
            BlockEntity blockEntity = level.getBlockEntity(pos = event.getPos());
            if (!(blockEntity instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
            Player player = event.getEntity();
            ItemStack handStack = player.getMainHandItem();
            ItemStack tileStack = tile.getStack();
            BlockState oldState = level.getBlockState(pos);
            if (tileStack.isEmpty()) {
                if (!(handStack.getItem() instanceof IRelicItem)) {
                    return;
                }
                tile.setStack(handStack.split(1));
            } else if (player.isShiftKeyDown()) {
                Item item = tileStack.getItem();
                if (!(item instanceof IRelicItem)) {
                    return;
                }
                IRelicItem relic = (IRelicItem)item;
                relic.setItemResearched(player, true);
                if (level.isClientSide()) {
                    ResearchingTableBlock.openGui(pos);
                }
            } else {
                level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), tileStack));
                tile.setStack(ItemStack.EMPTY);
            }
            tile.setChanged();
            level.sendBlockUpdated(pos, oldState, level.getBlockState(pos), 3);
        }
    }
}

