/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.stats;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public interface SpawnerStat<T> {
    public Codec<T> getValueCodec();

    public T getValue(ApothSpawnerTile var1);

    public void setValue(ApothSpawnerTile var1, T var2);

    public Component getTooltip(ApothSpawnerTile var1);

    public boolean applyModifier(ApothSpawnerTile var1, T var2, Optional<T> var3, Optional<T> var4);

    default public ResourceLocation getId() {
        return SpawnerStats.REGISTRY.getKey((Object)this);
    }

    default public MutableComponent name() {
        return Component.translatable((String)this.getId().toLanguageKey("stat"));
    }

    default public MutableComponent desc() {
        return Component.translatable((String)this.getId().toLanguageKey("stat", "desc"));
    }

    default public String formatValue(T value) {
        return value.toString();
    }

    public static Component createTooltip(SpawnerStat<?> stat, MutableComponent value) {
        return Component.translatable((String)"misc.apothic_spawners.value_concat", (Object[])new Object[]{stat.name(), value.withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.GREEN);
    }

    public static Component createTooltip(SpawnerStat<?> stat, String value) {
        return SpawnerStat.createTooltip(stat, Component.literal((String)value));
    }
}

