/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public record StatModifier<T>(SpawnerStat<T> stat, T value, Optional<T> min, Optional<T> max) {
    private static final Map<SpawnerStat<?>, MapCodec<StatModifier<?>>> CODEC_CACHE = new HashMap();
    public static final Codec<StatModifier<?>> CODEC = Codec.lazyInitialized(() -> SpawnerStats.REGISTRY.byNameCodec().dispatch(StatModifier::stat, StatModifier::modifierCodec));

    public StatModifier(SpawnerStat<T> stat, T value) {
        this(stat, value, Optional.empty(), Optional.empty());
    }

    public boolean apply(ApothSpawnerTile tile) {
        return this.stat.applyModifier(tile, this.value, this.min, this.max);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.stat.getId());
        buf.writeNbt((Tag)StatModifier.modifierCodec(this.stat).codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow());
    }

    public String getFormattedValue() {
        return this.stat.formatValue(this.value);
    }

    public static StatModifier<?> read(FriendlyByteBuf buf) {
        SpawnerStat stat = (SpawnerStat)SpawnerStats.REGISTRY.get(buf.readResourceLocation());
        return (StatModifier)((Pair)StatModifier.modifierCodec(stat).codec().decode((DynamicOps)NbtOps.INSTANCE, (Object)buf.readNbt()).getOrThrow()).getFirst();
    }

    public static <T> MapCodec<StatModifier<T>> modifierCodec(SpawnerStat<T> stat) {
        return CODEC_CACHE.computeIfAbsent(stat, s -> StatModifier.createModifierCodec(s));
    }

    private static <T> MapCodec<StatModifier<T>> createModifierCodec(SpawnerStat<T> stat) {
        return RecordCodecBuilder.mapCodec(inst -> inst.group((App)stat.getValueCodec().fieldOf("value").forGetter(StatModifier::value), (App)stat.getValueCodec().optionalFieldOf("min").forGetter(StatModifier::min), (App)stat.getValueCodec().optionalFieldOf("max").forGetter(StatModifier::max)).apply((Applicative)inst, (value, min, max) -> new StatModifier<Object>(stat, value, (Optional<Object>)min, (Optional<Object>)max)));
    }
}

