/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners;

import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ASConfig {
    public static final String[] DEFAULT_BANNED_MOBS = new String[]{"minecraft:warden", "minecraft:elder_guardian"};
    public static int spawnerSilkLevel;
    public static int spawnerSilkDamage;
    public static float capturingDropChance;
    public static Set<ResourceLocation> bannedMobs;

    public static void load() {
        String[] bans;
        Configuration config = new Configuration("apothic_spawners");
        config.setTitle("Apotheosis Spawner Module Configuration");
        spawnerSilkLevel = config.getInt("Spawner Silk Level", "general", 1, -1, 127, "The level of silk touch needed to harvest a spawner.  Set to -1 to disable, 0 to always drop.  The enchantment module can increase the max level of silk touch.\nSynced.");
        spawnerSilkDamage = config.getInt("Spawner Silk Damage", "general", 100, 0, 100000, "The durability damage dealt to an item that silk touches a spawner.\nServer-authoritative.");
        capturingDropChance = config.getFloat("Capturing Drop Chance", "general", 0.005f, 0.001f, 1.0f, "The per-level drop chance (1 = 100%) of Spawn Eggs when using Capturing.\nSynced.");
        bannedMobs.clear();
        for (String s : bans = config.getStringList("Banned Mobs", "spawn_eggs", DEFAULT_BANNED_MOBS, "A list of entity registry names that cannot be applied to spawners via egg.\nSynced.")) {
            try {
                bannedMobs.add(ResourceLocation.parse((String)s));
            }
            catch (ResourceLocationException ex) {
                ApothicSpawners.LOGGER.error("Invalid entry {} detected in the spawner banned mobs list.", (Object)s);
                ex.printStackTrace();
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        bannedMobs = new HashSet<ResourceLocation>();
    }

    public record ConfigPayload(int spawnerSilkLevel, float capturingDropChance, Set<ResourceLocation> bannedMobs) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ConfigPayload> TYPE = new CustomPacketPayload.Type(ApothicSpawners.loc("config"));
        public static final StreamCodec<FriendlyByteBuf, ConfigPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ConfigPayload::spawnerSilkLevel, (StreamCodec)ByteBufCodecs.FLOAT, ConfigPayload::capturingDropChance, (StreamCodec)ByteBufCodecs.collection(HashSet::new, (StreamCodec)ResourceLocation.STREAM_CODEC), ConfigPayload::bannedMobs, ConfigPayload::new);

        public ConfigPayload() {
            this(spawnerSilkLevel, capturingDropChance, bannedMobs);
        }

        public CustomPacketPayload.Type<ConfigPayload> type() {
            return TYPE;
        }

        public static class Provider
        implements PayloadProvider<ConfigPayload> {
            public CustomPacketPayload.Type<ConfigPayload> getType() {
                return TYPE;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, ConfigPayload> getCodec() {
                return CODEC;
            }

            public void handle(ConfigPayload msg, IPayloadContext ctx) {
                ASConfig.spawnerSilkLevel = msg.spawnerSilkLevel;
                ASConfig.capturingDropChance = msg.capturingDropChance;
                ASConfig.bannedMobs = msg.bannedMobs;
            }

            public List<ConnectionProtocol> getSupportedProtocols() {
                return List.of(ConnectionProtocol.PLAY);
            }

            public Optional<PacketFlow> getFlow() {
                return Optional.of(PacketFlow.CLIENTBOUND);
            }

            public String getVersion() {
                return "1";
            }
        }
    }
}

