/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.function.Supplier;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.loader.Env;
import me.ichun.mods.ichunutil.loader.Side;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface LoaderDelegate {
    public static void assignLoaderDelegate() {
        Class<?> clz;
        try {
            clz = Class.forName("me.ichun.mods.ichunutil.loader.fabric.LoaderDelegateFabric");
        }
        catch (ClassNotFoundException ignored) {
            try {
                clz = Class.forName("me.ichun.mods.ichunutil.loader.forge.LoaderDelegateForge");
            }
            catch (ClassNotFoundException ignored2) {
                try {
                    clz = Class.forName("me.ichun.mods.ichunutil.loader.neoforge.LoaderDelegateNeoForge");
                }
                catch (ClassNotFoundException ignored3) {
                    clz = null;
                }
            }
        }
        if (clz == null) {
            throw new RuntimeException("Unable to create determine Loader Delegate type!");
        }
        try {
            iChunUtil.loaderDelegate = (LoaderDelegate)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create Loader Delegate of type " + clz.getName() + "!", e);
        }
        iChunUtil.d().assignEventHandlerServer();
        if (iChunUtil.d().getSide().isClient()) {
            iChunUtil.d().assignEventHandlerClient();
        }
    }

    public Env env();

    public void assignEventHandlerServer();

    @OnlyIn(value=Dist.CLIENT)
    public void assignEventHandlerClient();

    default public boolean isDevEnvironment() {
        return SharedConstants.IS_RUNNING_IN_IDE;
    }

    public Path getModsDir();

    public Path getConfigDir();

    public <T extends ConfigBase> T registerConfig(T var1, Object ... var2);

    public Side getSide();

    public Side getEffectiveSide();

    public MinecraftServer getServer();

    public boolean isModLoaded(String var1);

    public boolean sendIMCMessage(String var1, String var2, String var3, Supplier<?> var4);

    default public Block registryBlock(ResourceLocation rl) {
        return (Block)BuiltInRegistries.BLOCK.get(rl);
    }

    default public SoundEvent registrySoundEvents(ResourceLocation rl) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(rl);
    }

    public void registerAddReloadListener(PreparableReloadListener var1);
}

