/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.entity.ErroredEntityRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRendererMap
implements Map<EntityType<?>, EntityRenderer<?>> {
    private final Map<EntityType<?>, EntityRendererProvider<?>> rendererProviders;
    private final LoadingCache<EntityType<?>, EntityRenderer<?>> rendererMap;
    private final EntityRendererProvider.Context context;

    public EntityRendererMap(Map<EntityType<?>, EntityRendererProvider<?>> rendererProviders, EntityRendererProvider.Context context) {
        this.rendererProviders = rendererProviders;
        this.context = context;
        this.rendererMap = CacheBuilder.newBuilder().build((CacheLoader)new RenderConstructor());
    }

    @Override
    public int size() {
        return this.rendererProviders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rendererProviders.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.rendererProviders.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return false;
    }

    @Override
    public EntityRenderer<?> get(Object o) {
        try {
            EntityRenderer renderer = (EntityRenderer)this.rendererMap.get((Object)((EntityType)o));
            if (renderer == null) {
                throw new AssertionError((Object)"Returned entity renderer should never be null");
            }
            return renderer;
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public EntityRenderer<?> put(EntityType<?> entityType, EntityRenderer<?> entityRenderer) {
        EntityRenderer old = (EntityRenderer)this.rendererMap.getIfPresent(entityType);
        this.rendererMap.put(entityType, entityRenderer);
        return old;
    }

    @Override
    public EntityRenderer<?> remove(Object o) {
        EntityRenderer r = (EntityRenderer)this.rendererMap.getIfPresent(o);
        this.rendererMap.invalidate(o);
        return r;
    }

    @Override
    public void putAll(@NotNull Map<? extends EntityType<?>, ? extends EntityRenderer<?>> map) {
        this.rendererMap.putAll(map);
    }

    @Override
    public void clear() {
        this.rendererMap.invalidateAll();
    }

    @Override
    @NotNull
    public Set<EntityType<?>> keySet() {
        return this.rendererProviders.keySet();
    }

    @Override
    @NotNull
    public Collection<EntityRenderer<?>> values() {
        return this.rendererMap.asMap().values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<EntityType<?>, EntityRenderer<?>>> entrySet() {
        return this.rendererMap.asMap().entrySet();
    }

    class RenderConstructor
    extends CacheLoader<EntityType<?>, EntityRenderer<?>> {
        RenderConstructor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntityRenderer<?> load(EntityType<?> key) throws Exception {
            EntityRendererProvider<?> provider = EntityRendererMap.this.rendererProviders.get(key);
            Class<EntityRenderers> clazz = EntityRenderers.class;
            synchronized (EntityRenderers.class) {
                ErroredEntityRenderer renderer;
                try {
                    if (provider == null) {
                        throw new RuntimeException("Provider not registered");
                    }
                    renderer = provider.create(EntityRendererMap.this.context);
                    ModernFix.LOGGER.info("Loaded entity {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(key));
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Failed to create entity model for " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey(key)) + ":", (Throwable)e);
                    renderer = new ErroredEntityRenderer(EntityRendererMap.this.context);
                }
                return renderer;
            }
        }
    }
}

