/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.mixin;

import de.cech12.usefulhats.item.AbstractHatItem;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class CommonItemStackMixin
implements DataComponentHolder {
    @Shadow
    public abstract Item getItem();

    @Inject(at={@At(value="HEAD")}, method={"getMaxDamage"}, cancellable=true)
    public void getMaxDamageProxy(CallbackInfoReturnable<Integer> cir) {
        Item item = this.getItem();
        if (item instanceof AbstractHatItem) {
            AbstractHatItem hatItem = (AbstractHatItem)item;
            cir.setReturnValue((Object)hatItem.getDurabilityFromConfig());
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isDamageableItem"}, cancellable=true)
    public void isDamageableItemProxy(CallbackInfoReturnable<Boolean> cir) {
        Item item = this.getItem();
        if (item instanceof AbstractHatItem) {
            AbstractHatItem hatItem = (AbstractHatItem)item;
            cir.setReturnValue((Object)(hatItem.getDurabilityFromConfig() > 0 && !this.has(DataComponents.UNBREAKABLE) ? 1 : 0));
            cir.cancel();
        }
    }
}

