/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats;

import de.cech12.usefulhats.item.IAttackTargetChanger;
import de.cech12.usefulhats.item.IBreakSpeedChanger;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IItemFishedListener;
import de.cech12.usefulhats.item.IItemUseListener;
import de.cech12.usefulhats.item.ILivingDropsListener;
import de.cech12.usefulhats.item.ILivingJumpListener;
import de.cech12.usefulhats.item.IMobEntityChanger;
import de.cech12.usefulhats.item.IRightClickListener;
import de.cech12.usefulhats.platform.Services;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class UsefulHatsEventUtils {
    public static float onBreakSpeedCalculation(Player player, BlockState state, float actualSpeed) {
        float[] newSpeed = new float[]{actualSpeed};
        Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)player).stream().filter(stack -> stack.getItem() instanceof IBreakSpeedChanger).forEach(stack -> {
            newSpeed[0] = ((IBreakSpeedChanger)stack.getItem()).onBreakSpeedEvent(player, state, newSpeed[0], (ItemStack)stack);
        });
        return newSpeed[0];
    }

    public static void onBlockBreak(Player player, BlockState state) {
        Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)player).stream().filter(stack -> stack.getItem() instanceof IBreakSpeedChanger).forEach(stack -> ((IBreakSpeedChanger)stack.getItem()).onBreakEvent(player, state, (ItemStack)stack));
    }

    public static void onEntityJoinWorld(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Services.REGISTRY.getAllHatItems().stream().filter(item -> item instanceof IMobEntityChanger).forEach(item -> ((IMobEntityChanger)item).onEntityJoinWorldEvent(livingEntity));
        }
    }

    public static void onItemFished(Player entity) {
        Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)entity).stream().filter(stack -> stack.getItem() instanceof IItemFishedListener).forEach(stack -> ((IItemFishedListener)stack.getItem()).onItemFishedListener(entity, (ItemStack)stack));
    }

    public static void onLivingDiesBecauseOf(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Services.REGISTRY.getEquippedHatItemStacks(livingEntity).stream().filter(stack -> stack.getItem() instanceof ILivingDropsListener).forEach(stack -> ((ILivingDropsListener)stack.getItem()).onLivingDropsEvent(livingEntity, (ItemStack)stack));
        }
    }

    public static void onLivingJump(LivingEntity entity) {
        Services.REGISTRY.getEquippedHatItemStacks(entity).stream().filter(stack -> stack.getItem() instanceof ILivingJumpListener).forEach(stack -> ((ILivingJumpListener)stack.getItem()).onLivingJumpEvent(entity, (ItemStack)stack));
    }

    public static int onLivingStartsUsingItem(LivingEntity entity, ItemStack usedStack, int actualDuration) {
        int[] newDuration = new int[]{actualDuration};
        Services.REGISTRY.getEquippedHatItemStacks(entity).stream().filter(stack -> stack.getItem() instanceof IItemUseListener).forEach(stack -> {
            newDuration[0] = ((IItemUseListener)stack.getItem()).onItemUseEventStart(entity, usedStack, newDuration[0], (ItemStack)stack);
        });
        return newDuration[0];
    }

    public static void onEquip(LivingEntity entity, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IEquipmentChangeListener) {
            IEquipmentChangeListener equipmentChangeListener = (IEquipmentChangeListener)item;
            equipmentChangeListener.onEquippedHatItem(entity, stack);
        }
    }

    public static void onUnequip(LivingEntity entity, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IEquipmentChangeListener) {
            IEquipmentChangeListener equipmentChangeListener = (IEquipmentChangeListener)item;
            equipmentChangeListener.onUnequippedHatItem(entity, stack);
        }
    }

    public static boolean shouldEntityAvoidChangingTarget(LivingEntity entity, LivingEntity target) {
        return target != null && Services.REGISTRY.getEquippedHatItemStacks(target).stream().filter(stack -> stack.getItem() instanceof IAttackTargetChanger).anyMatch(stack -> ((IAttackTargetChanger)stack.getItem()).avoidMobChangingTarget((ItemStack)stack, entity, target));
    }

    public static boolean shouldRightClickBeCancelled(Level level, Player player, ItemStack usedStack, InteractionHand hand) {
        return Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)player).stream().filter(stack -> stack.getItem() instanceof IRightClickListener).anyMatch(stack -> ((IRightClickListener)stack.getItem()).onRightClickItemEvent(level, player, usedStack, hand, (ItemStack)stack));
    }
}

