/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PillarBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> CAP = List.of(AthenaQuad.withSprite(0));
    private final Int2ObjectMap<Material> materials;

    public PillarBlockModel(Int2ObjectMap<Material> materials) {
        this.materials = materials;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        boolean max;
        if (!state.hasProperty((Property)BlockStateProperties.AXIS)) {
            return List.of(AthenaQuad.withRotation(4, Rotation.NONE));
        }
        if (state.getValue((Property)BlockStateProperties.AXIS) == direction.getAxis()) {
            return CAP;
        }
        BlockState appearance = level.getAppearance(pos, direction, state, pos);
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
        Rotation rotate = CtmUtils.getPillarRotation(axis, direction);
        Pair<Direction, Direction> minMax = AthenaUtils.getMinMax(axis);
        boolean min = level.getAppearance(pos.relative((Direction)minMax.getFirst()), direction, appearance, pos) == appearance;
        boolean bl = max = level.getAppearance(pos.relative((Direction)minMax.getSecond()), direction, appearance, pos) == appearance;
        if (min && max) {
            return List.of(AthenaQuad.withRotation(2, rotate));
        }
        if (min) {
            return List.of(AthenaQuad.withRotation(3, rotate));
        }
        if (max) {
            return List.of(AthenaQuad.withRotation(1, rotate));
        }
        return List.of(AthenaQuad.withRotation(4, rotate));
    }

    @Override
    public Map<Direction, List<AthenaQuad>> getDefaultQuads(Direction direction) {
        HashMap<Direction, List<AthenaQuad>> quads = new HashMap<Direction, List<AthenaQuad>>(Direction.values().length);
        for (Direction dir : Direction.values()) {
            quads.put(dir, List.of(AthenaQuad.withRotation(4, Rotation.NONE)));
        }
        return quads;
    }

    @Override
    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((Material)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<Material> materials = Factory.parseMaterials(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"));
            return () -> new PillarBlockModel(materials);
        }

        private static Int2ObjectMap<Material> parseMaterials(JsonObject json) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"particle")));
            materials.put(4, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"self")));
            materials.put(1, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"top")));
            materials.put(2, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"center")));
            materials.put(3, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"bottom")));
            return materials;
        }
    }
}

